/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentPresentationController;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.kns.web.ui.SectionBridge;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;

public abstract class ContractsGrantsBillingMaintainable
extends FinancialSystemMaintainable {
    private static final Logger LOG = LogManager.getLogger();

    public List<Section> getCoreSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        ArrayList<Section> sections = new ArrayList<Section>();
        MaintenanceDocumentRestrictions maintenanceRestrictions = KNSServiceLocator.getBusinessObjectAuthorizationService().getMaintenanceDocumentRestrictions(document, GlobalVariables.getUserSession().getPerson());
        MaintenanceDocumentPresentationController maintenanceDocumentPresentationController = (MaintenanceDocumentPresentationController)this.getDocumentHelperService().getDocumentPresentationController((Document)document);
        Set conditionallyRequiredFields = maintenanceDocumentPresentationController.getConditionallyRequiredPropertyNames(document);
        List sectionDefinitions = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(this.getDocumentTypeName());
        try {
            Collection<?> sectionIdsToIgnore = this.getSectionIdsToIgnore();
            for (MaintainableSectionDefinition maintSectionDef : sectionDefinitions) {
                ArrayList<String> displayedFieldNames = new ArrayList<String>();
                if (maintenanceRestrictions.isHiddenSectionId(maintSectionDef.getId()) || sectionIdsToIgnore.contains(maintSectionDef.getId())) continue;
                for (MaintainableItemDefinition item : maintSectionDef.getMaintainableItems()) {
                    if (!(item instanceof MaintainableFieldDefinition)) continue;
                    displayedFieldNames.add(item.getName());
                }
                Section section = SectionBridge.toSection((MaintainableSectionDefinition)maintSectionDef, (BusinessObject)this.getBusinessObject(), (Maintainable)this, (Maintainable)oldMaintainable, (String)this.getMaintenanceAction(), displayedFieldNames, (Set)conditionallyRequiredFields);
                if (maintenanceRestrictions.isReadOnlySectionId(maintSectionDef.getId())) {
                    section.setReadOnly(true);
                }
                sections.add(section);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            LOG.error("Unable to create instance of object class{}", supplierArray);
            throw new RuntimeException("Unable to create instance of object class" + e.getMessage());
        }
        return sections;
    }

    protected abstract Collection<?> getSectionIdsToIgnore();
}

