/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.sys.datatools.liquimongo.change.AddNodeHandler;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class AddNodeHandlerTest {
    private AddNodeHandler addNodeHandler;
    private MongoOperations mongoTemplate;

    @Before
    public void setup() {
        this.addNodeHandler = new AddNodeHandler();
        this.mongoTemplate = (MongoOperations)EasyMock.createMock(MongoOperations.class);
    }

    @Test
    public void testHandlesAddNodes() throws Exception {
        String testJson = "{ \"changeType\": \"addNode\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should handle addNode element", (Object)true, (Object)this.addNodeHandler.handlesChange(testNode));
    }

    @Test
    public void testDoesNotHandleDeleteDocument() throws Exception {
        String testJson = "{ \"changeType\": \"deleteDocument\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should not handle deleteDocument element", (Object)false, (Object)this.addNodeHandler.handlesChange(testNode));
    }

    @Test
    public void testMakeChangeAddNode() throws Exception {
        Query q = new Query(Criteria.where((String)"myId").is((Object)"10"));
        EasyMock.expect((Object)this.mongoTemplate.findOne(q, DBObject.class, "collection")).andReturn((Object)this.createSampleDocumentBeforeAddition());
        this.mongoTemplate.remove(q, "collection");
        EasyMock.expectLastCall();
        this.mongoTemplate.save((Object)this.createSampleDocumentAfterAddition(), "collection");
        EasyMock.replay((Object[])new Object[]{this.mongoTemplate});
        String testJson = "{ \"changeType\": \"addNode\",\"collectionName\": \"collection\",\"query\": { \"myId\": \"10\"},\"path\": \"$..link\",\"addBeforeNode\": { \"label\" : \"Label2\"},\"value\": { \"label\" : \"Label5\"}  }";
        this.addNodeHandler.setMongoTemplate(this.mongoTemplate);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        this.addNodeHandler.makeChange(testNode);
        EasyMock.verify((Object[])new Object[]{this.mongoTemplate});
    }

    private DBObject createSampleDocumentAfterAddition() {
        return (DBObject)JSON.parse((String)"{ \"link\": [{\"label\": \"Label1\"}, {\"label\": \"Label5\"}, {\"label\": \"Label2\"}] }");
    }

    private DBObject createSampleDocumentBeforeAddition() {
        return (DBObject)JSON.parse((String)"{ \"link\": [{\"label\": \"Label1\"}, {\"label\": \"Label2\"}] }");
    }
}

