/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.sys.datatools.liquimongo.change.DeleteDocumentsHandler;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class DeleteDocumentsHandlerTest {
    private DeleteDocumentsHandler deleteDocumentsHandler;
    private MongoOperations mongoTemplate;

    @Before
    public void setup() {
        this.deleteDocumentsHandler = new DeleteDocumentsHandler();
        this.mongoTemplate = (MongoOperations)EasyMock.createMock(MongoOperations.class);
    }

    @Test
    public void testHandlesDeleteDocuments() throws Exception {
        String testJson = "{ \"changeType\": \"deleteDocument\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should handle deleteDocument element", (Object)true, (Object)this.deleteDocumentsHandler.handlesChange(testNode));
    }

    @Test
    public void testDoesNotHandleAddDocument() throws Exception {
        String testJson = "{ \"changeType\": \"addDocument\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should not handle addDocument element", (Object)false, (Object)this.deleteDocumentsHandler.handlesChange(testNode));
    }

    @Test
    public void testMakeChangeDeletesDocuments() throws Exception {
        Query q = new Query(Criteria.where((String)"myId").is((Object)"10"));
        this.mongoTemplate.remove(q, "collection");
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mongoTemplate});
        String testJson = "{ \"changeType\": \"deleteDocument\",\"collectionName\": \"collection\",\"query\": { \"myId\": \"10\"} }";
        this.deleteDocumentsHandler.setMongoTemplate(this.mongoTemplate);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        this.deleteDocumentsHandler.makeChange(testNode);
        EasyMock.verify((Object[])new Object[]{this.mongoTemplate});
    }

    @Test
    public void testMissingFieldGivesGoodError() throws Exception {
        this.deleteDocumentsHandler.setMongoTemplate(this.mongoTemplate);
        String testJson = "{ \"changeType\": \"deleteDocuments\",\"query\": { \"myId\": \"10\"} }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        try {
            this.deleteDocumentsHandler.makeChange(testNode);
            Assert.fail((String)"Method should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

