/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.sys.datatools.liquimongo.change.DeleteNodeHandler;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class DeleteNodeHandlerTest {
    private DeleteNodeHandler deleteNodeHandler;
    private MongoOperations mongoTemplate;

    @Before
    public void setup() {
        this.deleteNodeHandler = new DeleteNodeHandler();
        this.mongoTemplate = (MongoOperations)EasyMock.createMock(MongoOperations.class);
    }

    @Test
    public void testHandlesDeleteNodes() throws Exception {
        String testJson = "{ \"changeType\": \"deleteNode\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should handle deleteNode element", (Object)true, (Object)this.deleteNodeHandler.handlesChange(testNode));
    }

    @Test
    public void testDoesNotHandleDeleteDocument() throws Exception {
        String testJson = "{ \"changeType\": \"deleteDocument\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should not handle deleteDocument element", (Object)false, (Object)this.deleteNodeHandler.handlesChange(testNode));
    }

    @Test
    public void testMakeChangeDeleteNode() throws Exception {
        Query q = new Query(Criteria.where((String)"myId").is((Object)"10"));
        EasyMock.expect((Object)this.mongoTemplate.findOne(q, DBObject.class, "collection")).andReturn((Object)this.createSampleDocumentBeforeRemoval());
        this.mongoTemplate.remove(q, "collection");
        EasyMock.expectLastCall();
        this.mongoTemplate.save((Object)this.createSampleDocumentAfterRemoval(), "collection");
        EasyMock.replay((Object[])new Object[]{this.mongoTemplate});
        String testJson = "{ \"changeType\": \"deleteNode\",\"collectionName\": \"collection\",\"query\": { \"myId\": \"10\"},\"revertPath\": \"$..link\",\"path\": \"$..link[?(@.label=='Label5')]\" }";
        this.deleteNodeHandler.setMongoTemplate(this.mongoTemplate);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        this.deleteNodeHandler.makeChange(testNode);
        EasyMock.verify((Object[])new Object[]{this.mongoTemplate});
    }

    private DBObject createSampleDocumentBeforeRemoval() {
        return (DBObject)JSON.parse((String)"{ \"link\": [{\"label\": \"Label1\"}, {\"label\": \"Label5\"}, {\"label\": \"Label2\"}] }");
    }

    private DBObject createSampleDocumentAfterRemoval() {
        return (DBObject)JSON.parse((String)"{ \"link\": [{\"label\": \"Label1\"}, {\"label\": \"Label2\"}] }");
    }
}

