/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquimongo.change;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class JsonUtils {
    public static Query getQueryFromJson(JsonNode query) {
        Query q = new Query();
        Iterator items = query.fieldNames();
        while (items.hasNext()) {
            String key = (String)items.next();
            q.addCriteria(Criteria.where((String)key).is((Object)query.get(key).asText()));
        }
        return q;
    }

    public static String calculateHash(JsonNode node) {
        try {
            byte[] bytesOfMessage = node.toString().getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5hash = md.digest(bytesOfMessage);
            return Hex.encodeHexString((byte[])md5hash);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Unable to hash change", e);
        }
    }

    public static Map<String, Object> getMapFromJson(JsonNode node) {
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.convertValue((Object)node, Map.class);
    }
}

