/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquirelational;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;

public class LiquiRelational {
    private static final Logger LOG = LogManager.getLogger(LiquiRelational.class);
    public static final Pattern liquirelationalPatternLegacy = Pattern.compile("\\d\\d\\d\\d-\\d\\d.xml");
    public static final Pattern liquirelationalPatternRelease = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\d.xml");
    public static final Pattern liquirelationalPatternNextRelease = Pattern.compile("next-release.xml");
    protected static final String UPDATE_DATABASE_FULL_REBUILD = "updateDatabaseFullRebuild";
    protected static final String UPDATE_DATABASE_MANUAL_START = "updateDatabaseManualStart";
    protected static final String UPDATE_DATABASE_MANUAL_END = "updateDatabaseManualEnd";
    protected static final String UPDATE_DATABASE_CONTEXT = "updateDatabaseContext";
    protected static final String UPDATE_DATABASE_PACKAGES = "updateDatabasePackages";
    protected static final String UPDATE_DATABASE_PACKAGES_RICE = "updateDatabasePackagesRice";
    protected static final LiquiRelationalFileComparator liquiRelationalFileComparator = new LiquiRelationalFileComparator();
    private ClassPathXmlApplicationContext applicationContext;
    protected Properties properties = null;

    public LiquiRelational() {
    }

    public LiquiRelational(Properties properties) {
        this.properties = properties;
    }

    public static void main(String[] args) {
        Configurator.initialize((Configuration)new DefaultConfiguration());
        LiquiRelational liquiRelational = new LiquiRelational();
        liquiRelational.updateDatabase();
        System.exit(0);
    }

    public void updateDatabase() {
        this.initializeContext();
        this.applyUpdates();
        this.applicationContext.close();
    }

    private void initializeContext() {
        long startInit = System.currentTimeMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info("Initializing LiquiRelational Context...");
        }
        this.applicationContext = new ClassPathXmlApplicationContext("org/kuali/kfs/sys/datatools/liquirelational/kfs-liqui-relational-bootstrap.xml");
        if (this.properties != null) {
            this.applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)new PropertiesSource("properties", this.properties));
        } else {
            this.properties = (Properties)this.applicationContext.getBean("properties", Properties.class);
        }
        this.applicationContext.start();
        long endInit = System.currentTimeMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info("...LiquiRelational Context successfully initialized, startup took " + (endInit - startInit) + " ms.");
        }
    }

    private void applyUpdates() {
        this.applyDatabaseUpdates("dataSource", UPDATE_DATABASE_PACKAGES);
        this.applyDatabaseUpdates("riceDataSource", UPDATE_DATABASE_PACKAGES_RICE);
    }

    private void applyDatabaseUpdates(String dataSource, String databaseUpdatePackages) {
        DataSource kfsDataSource = (DataSource)this.applicationContext.getBean(dataSource, DataSource.class);
        List<String> packages = this.getBaseListProperty(databaseUpdatePackages);
        if (this.isEmptyList(packages)) {
            LOG.info(databaseUpdatePackages + " property is empty, nothing to update.");
        } else {
            this.updateDatabase(kfsDataSource, packages);
        }
    }

    private boolean isEmptyList(List<String> packages) {
        if (CollectionUtils.isEmpty(packages)) {
            return true;
        }
        for (String pkg : packages) {
            if (!StringUtils.isNotBlank((CharSequence)pkg)) continue;
            return false;
        }
        return true;
    }

    private void updateDatabase(DataSource dataSource, List<String> packages) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(this.applicationContext.getClassLoader());
            String liquibaseContext = this.getBaseProperty(UPDATE_DATABASE_CONTEXT);
            this.runUpdatesPhase(database, (ResourceAccessor)resourceAccessor, liquibaseContext, packages);
        }
        catch (SQLException | DatabaseException e) {
            LOG.error("Failed to get datasource.", e);
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOG.warn("Failed to get close connection.", (Throwable)e);
                    connection = null;
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private List<String> getPhasesToRun(List<String> packages) {
        List<String> phases = this.getManualPhasesToRun(packages);
        if (phases == null) {
            phases = this.getAutoPhasesToRun(packages);
        }
        return phases;
    }

    private List<String> getManualPhasesToRun(List<String> packages) {
        String start = this.getBaseProperty(UPDATE_DATABASE_MANUAL_START);
        String end = this.getBaseProperty(UPDATE_DATABASE_MANUAL_END);
        if (start == null) {
            return null;
        }
        int startNumber = 0;
        int endNumber = 0;
        try {
            startNumber = Integer.parseInt(start);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid parameter: updateDatabaseManualStart");
        }
        try {
            endNumber = Integer.parseInt(end);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid parameter: updateDatabaseManualEnd");
        }
        if (startNumber < 1 || startNumber > 5) {
            throw new RuntimeException("Invalid parameter: updateDatabaseManualStart");
        }
        if (endNumber < 1 || endNumber > 5) {
            throw new RuntimeException("Invalid parameter: updateDatabaseManualEnd");
        }
        LOG.info("getManualPhasesToRun() running phase " + startNumber + " to " + endNumber);
        ArrayList<String> phaseFilenames = new ArrayList<String>();
        for (int i = startNumber; i <= endNumber; ++i) {
            phaseFilenames.addAll(this.findFilenamesForPhase(i, packages));
        }
        return phaseFilenames;
    }

    private List<String> getAutoPhasesToRun(List<String> packages) {
        String updateDatabaseFullRebuild = this.getBaseProperty(UPDATE_DATABASE_FULL_REBUILD);
        ArrayList<String> phaseFilenames = new ArrayList<String>();
        if (Boolean.parseBoolean(updateDatabaseFullRebuild)) {
            LOG.info("getAutoPhasesToRun() Running all phases");
            for (int i = 1; i < 5; ++i) {
                phaseFilenames.addAll(this.findFilenamesForPhase(i, packages));
            }
        } else {
            LOG.info("getAutoPhasesToRun() Running phase 5 only");
        }
        phaseFilenames.addAll(this.findFilenamesForPhase(5, packages));
        return phaseFilenames;
    }

    private void runUpdatesPhase(Database database, ResourceAccessor resourceAccessor, String liquibaseContext, List<String> packages) {
        List<String> phaseFilenames = this.getPhasesToRun(packages);
        for (String filename : phaseFilenames) {
            try {
                LOG.info("Processing " + filename);
                Liquibase liquibase = new Liquibase(filename, resourceAccessor, database);
                liquibase.update(liquibaseContext);
            }
            catch (LiquibaseException e) {
                throw new RuntimeException("Failed to create Liquibase for " + filename, e);
            }
        }
    }

    private List<String> findFilenamesForPhase(int phase, List<String> packages) {
        ArrayList<String> phaseFilenames = new ArrayList<String>();
        for (String pkg : packages) {
            if (StringUtils.isEmpty((CharSequence)pkg)) {
                LOG.info("Package is empty, no files to find.");
                continue;
            }
            String sourceName = "classpath:/" + pkg + "/db/phase" + phase + "/*.xml";
            try {
                ArrayList<String> tempFilenames = new ArrayList<String>();
                Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.applicationContext).getResources(sourceName);
                for (int i = 0; i < resources.length; ++i) {
                    tempFilenames.add(pkg + "/db/phase" + phase + "/" + resources[i].getFilename());
                }
                Collections.sort(tempFilenames, liquiRelationalFileComparator);
                phaseFilenames.addAll(tempFilenames);
            }
            catch (FileNotFoundException e) {
                LOG.warn("Failed to find files for " + sourceName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return phaseFilenames;
    }

    public String getBaseProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public List<String> getBaseListProperty(String propertyName) {
        if (this.properties.containsKey(propertyName)) {
            return Arrays.asList(this.properties.getProperty(propertyName).split(","));
        }
        return Collections.emptyList();
    }

    public static class LiquiRelationalFileComparator
    implements Comparator<String> {
        @Override
        public int compare(String qualifiedFilename1, String qualifiedFilename2) {
            String filename1 = qualifiedFilename1.substring(qualifiedFilename1.lastIndexOf(47) + 1);
            String filename2 = qualifiedFilename2.substring(qualifiedFilename2.lastIndexOf(47) + 1);
            boolean isLegacy1 = liquirelationalPatternLegacy.matcher(filename1).matches();
            boolean isLegacy2 = liquirelationalPatternLegacy.matcher(filename2).matches();
            boolean isRelease1 = liquirelationalPatternRelease.matcher(filename1).matches();
            boolean isRelease2 = liquirelationalPatternRelease.matcher(filename2).matches();
            boolean isNextRelease1 = liquirelationalPatternNextRelease.matcher(filename1).matches();
            boolean isNextRelease2 = liquirelationalPatternNextRelease.matcher(filename2).matches();
            int result = filename1.compareTo(filename2);
            if (isLegacy1 && isRelease2) {
                String yearMonth2;
                String yearMonth1 = filename1.substring(0, 7);
                result = yearMonth1.equals(yearMonth2 = filename2.substring(0, 7)) ? -1 : yearMonth1.compareTo(yearMonth2);
            } else if (isRelease1 && isLegacy2) {
                String yearMonth2;
                String yearMonth1 = filename1.substring(0, 7);
                result = yearMonth1.equals(yearMonth2 = filename2.substring(0, 7)) ? 1 : yearMonth1.compareTo(yearMonth2);
            } else if (isNextRelease1 && (isLegacy2 || isRelease2)) {
                result = 1;
            } else if ((isLegacy1 || isRelease1) && isNextRelease2) {
                result = -1;
            }
            return result;
        }
    }

    public static class PropertiesSource
    extends PropertySource<String> {
        protected Properties properties;

        public PropertiesSource(String name, Properties properties) {
            super(name);
            this.properties = properties;
        }

        public String getProperty(String s) {
            if (this.properties != null) {
                return String.valueOf(this.properties.get(s));
            }
            return null;
        }
    }
}

