/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.exportdata;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.kuali.kfs.sys.datatools.util.PropertyLoadingFactoryBean;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ExportData {
    private String rootDirectory;
    private String schema;
    private List<String> skipTableExpressions;
    private Map<Integer, String> typeNames;
    private ClassPathXmlApplicationContext applicationContext;
    private SimpleDateFormat dateFormat;
    public static final String DELIMITER = "~&~\t~&~";
    public static final String QUOTE = "'";
    public static final String HEADER_BEGIN = "HEADER[";
    public static final String HEADER_END = "]HEADER";
    public static final String RECORD_BEGIN = "RECORD[";
    public static final String RECORD_END = "]RECORD";
    public static final String COLUMN_SEPARATOR = "::";
    private static final String LIQUIBASE_BEGIN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\n   - The Kuali Financial System, a comprehensive financial management system for higher education.\n   - \n   - Copyright 2005-2017 Kuali, Inc.\n   - \n   - This program is free software: you can redistribute it and/or modify\n   - it under the terms of the GNU Affero General Public License as\n   - published by the Free Software Foundation, either version 3 of the\n   - License, or (at your option) any later version.\n   - \n   - This program is distributed in the hope that it will be useful,\n   - but WITHOUT ANY WARRANTY; without even the implied warranty of\n   - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n   - GNU Affero General Public License for more details.\n   - \n   - You should have received a copy of the GNU Affero General Public License\n   - along with this program.  If not, see <http://www.gnu.org/licenses/>.\n -->\n<databaseChangeLog xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" xmlns:ext=\"http://www.liquibase.org/xml/ns/dbchangelog-ext\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog-ext http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-ext.xsd http://www.liquibase.org/xml/ns/dbchangelog http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.4.xsd\">\n";
    private static final String LIQUIBASE_END = "</databaseChangeLog>\n";

    public static void main(String[] args) throws IOException {
        ExportData c = new ExportData();
        long startTime = System.nanoTime();
        c.go();
        long estimatedTime = System.nanoTime() - startTime;
        System.out.printf("\nTime run: %d seconds\n", estimatedTime / 1000L / 1000L / 1000L);
    }

    public void go() {
        this.dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSSS");
        this.initialize();
        DataSource kfsDataSource = (DataSource)this.applicationContext.getBean("dataSource", DataSource.class);
        try (Connection con = kfsDataSource.getConnection();){
            List<String> tableNames = this.getTableNames(con);
            for (String table : tableNames) {
                this.extractTable(con, table, this.rootDirectory);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void extractTable(Connection con, String table, String root) throws Exception {
        System.out.println(table);
        try (PreparedStatement ps = con.prepareStatement("select * from " + table);
             ResultSet rs = ps.executeQuery();){
            if (!rs.isBeforeFirst()) {
                return;
            }
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(root + table + ".xml")));){
                out.print(LIQUIBASE_BEGIN);
                out.print("  <changeSet id=\"IMPORT_" + table + "\" author=\"kfs\" context=\"demo,unit\">\n");
                out.print("    <customChange class=\"org.kuali.kfs.sys.datatools.util.TableDataLoader\">\n");
                out.print("      <param name=\"table\" value=\"" + table + "\"/>\n");
                out.print("      <param name=\"file\" value=\"org/kuali/kfs/core/db/phase2/" + table + ".dat\" />\n");
                out.print("    </customChange>\n");
                out.print("  </changeSet>\n");
                out.print(LIQUIBASE_END);
            }
            out = new PrintWriter(new BufferedWriter(new FileWriter(root + table + ".dat")));
            var9_15 = null;
            try {
                int i;
                ResultSetMetaData rsmd = rs.getMetaData();
                out.print("HEADER[~&~\t~&~");
                for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String typeName = this.typeNames.get(rsmd.getColumnType(i));
                    if (typeName == null) {
                        throw new RuntimeException("Unknown JDBC type: " + i);
                    }
                    out.print(rsmd.getColumnName(i) + COLUMN_SEPARATOR + typeName + DELIMITER);
                }
                out.print("]HEADER\n");
                while (rs.next()) {
                    out.print("RECORD[~&~\t~&~");
                    for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                        out.print(this.columnData(rsmd, rs, i) + DELIMITER);
                    }
                    out.print("]RECORD\n");
                }
            }
            catch (Throwable throwable) {
                var9_15 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var9_15 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var9_15.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
    }

    private String columnData(ResultSetMetaData rsmd, ResultSet rs, int i) throws SQLException {
        String value = rs.getString(i);
        int columnType = rsmd.getColumnType(i);
        if (value != null) {
            switch (columnType) {
                case 2004: {
                    Blob blob = rs.getBlob(i);
                    if (blob == null) break;
                    byte[] bytes = blob.getBytes(1L, (int)blob.length());
                    value = Base64.getEncoder().encodeToString(bytes);
                    break;
                }
                case 91: {
                    value = this.dateFormat.format(rs.getDate(i));
                    break;
                }
                case 93: {
                    value = this.dateFormat.format(rs.getTimestamp(i));
                    break;
                }
            }
            return QUOTE + value + QUOTE;
        }
        return "NULL";
    }

    private List<String> getTableNames(Connection con) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        try (ResultSet rs = con.getMetaData().getTables(null, this.schema, "%", new String[]{"TABLE"});){
            while (rs.next()) {
                String table = rs.getString(3);
                if (!this.skipTable(table)) {
                    tableNames.add(table);
                    continue;
                }
                System.out.println("Skipping " + table);
            }
        }
        return tableNames;
    }

    private boolean skipTable(String table) {
        for (String expression : this.skipTableExpressions) {
            if (!table.matches(expression)) continue;
            return true;
        }
        return false;
    }

    private void initialize() {
        this.applicationContext = new ClassPathXmlApplicationContext("org/kuali/kfs/sys/datatools/liquirelational/kfs-liqui-relational-bootstrap.xml");
        this.applicationContext.start();
        this.readProperties();
        this.loadTypeNames();
    }

    private void readProperties() {
        this.rootDirectory = PropertyLoadingFactoryBean.getBaseProperty("export.rootDirectory");
        if (!this.rootDirectory.endsWith(File.separator)) {
            this.rootDirectory = this.rootDirectory + File.separator;
        }
        this.schema = PropertyLoadingFactoryBean.getBaseProperty("export.schema");
        String skipTables = PropertyLoadingFactoryBean.getBaseProperty("export.skip");
        this.skipTableExpressions = skipTables != null ? Arrays.asList(skipTables.split(";")) : new ArrayList<String>();
    }

    private void loadTypeNames() {
        this.typeNames = new HashMap<Integer, String>();
        for (Field field : Types.class.getFields()) {
            try {
                this.typeNames.put((Integer)field.get(null), field.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }
}

