/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.liquirelational;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class LiquiRelational {
    private static final Logger LOG = LogManager.getLogger();
    private static final Map<Integer, String> LIQUIBASE_MASTER_FILES = Map.ofEntries(Map.entry(1, "org/kuali/kfs/db/liquibase-phase1-master.xml"), Map.entry(2, "org/kuali/kfs/db/liquibase-phase2-master.xml"), Map.entry(3, "org/kuali/kfs/db/liquibase-phase3-master.xml"), Map.entry(4, "org/kuali/kfs/db/liquibase-phase4-master.xml"), Map.entry(5, "org/kuali/kfs/db/liquibase-phase5-master.xml"));
    private static final String ADDITIONAL_PHASE5_LIQUIBASE_MASTER_FILE = "additional.phase5.liquibase.master.file";
    private static final String UPDATE_DATABASE_CONTEXT = "updateDatabaseContext";
    private static final String UPDATE_DATABASE_FULL_REBUILD = "updateDatabaseFullRebuild";
    private final String liquibaseContext;
    private final boolean fullRebuild;
    private final String additionalPhase5MasterFile;
    private final DataSource dataSource;
    private final ResourceAccessor resourceAccessor;

    public LiquiRelational(String liquibaseContext, boolean fullRebuild, String additionalPhase5MasterFile, DataSource dataSource, ResourceAccessor resourceAccessor) {
        this.liquibaseContext = liquibaseContext;
        this.fullRebuild = fullRebuild;
        this.additionalPhase5MasterFile = additionalPhase5MasterFile;
        this.dataSource = dataSource;
        this.resourceAccessor = resourceAccessor;
    }

    public static void main(String[] args) {
        try (LoggerContext ignored = Configurator.initialize((Configuration)new DefaultConfiguration());){
            ClassPathXmlApplicationContext applicationContext = LiquiRelational.initializeContext();
            Properties properties = (Properties)applicationContext.getBean("properties", Properties.class);
            String liquibaseContext = properties.getProperty(UPDATE_DATABASE_CONTEXT);
            boolean fullRebuild = Boolean.parseBoolean(properties.getProperty(UPDATE_DATABASE_FULL_REBUILD));
            String additionalPhase5MasterFile = properties.getProperty(ADDITIONAL_PHASE5_LIQUIBASE_MASTER_FILE);
            DataSource dataSource = (DataSource)applicationContext.getBean("dataSource", DataSource.class);
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(applicationContext.getClassLoader());
            new LiquiRelational(liquibaseContext, fullRebuild, additionalPhase5MasterFile, dataSource, (ResourceAccessor)resourceAccessor).applyUpdates();
            applicationContext.close();
        }
        System.exit(0);
    }

    private static ClassPathXmlApplicationContext initializeContext() {
        LOG.info("Initializing LiquiRelational Context...");
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/kuali/kfs/sys/datatools/liquirelational/kfs-liqui-relational-bootstrap.xml");
        applicationContext.start();
        LOG.info("...LiquiRelational Context successfully initialized");
        return applicationContext;
    }

    public void applyUpdates() {
        try (Connection connection = this.dataSource.getConnection();){
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            List<String> phaseFilenames = this.getPhasesToRun();
            this.runUpdatesPhase(database, phaseFilenames);
        }
        catch (SQLException | DatabaseException e) {
            LOG.error("Failed to get datasource.", e);
            throw new RuntimeException(e);
        }
    }

    private List<String> getPhasesToRun() {
        ArrayList<String> phaseFilenames = new ArrayList<String>();
        if (this.fullRebuild) {
            LOG.info("getAutoPhasesToRun() Running all phases");
            for (int i = 1; i < 5; ++i) {
                phaseFilenames.add(LIQUIBASE_MASTER_FILES.get(i));
            }
        } else {
            LOG.info("getAutoPhasesToRun() Running phase 5 only");
        }
        if (StringUtils.isNotBlank((CharSequence)this.additionalPhase5MasterFile)) {
            phaseFilenames.add(this.additionalPhase5MasterFile);
        }
        phaseFilenames.add(LIQUIBASE_MASTER_FILES.get(5));
        return phaseFilenames;
    }

    private void runUpdatesPhase(Database database, List<String> phaseFilenames) {
        for (String filename : phaseFilenames) {
            try {
                LOG.info("Processing {}", (Object)filename);
                Liquibase liquibase = new Liquibase(filename, this.resourceAccessor, database);
                liquibase.update(this.liquibaseContext);
            }
            catch (LiquibaseException e) {
                throw new RuntimeException("Failed to create Liquibase for " + filename, e);
            }
        }
    }
}

