/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.util.JSON;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.sys.datatools.liquimongo.change.UpdateDocumentHandler;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class UpdateDocumentHandlerTest {
    private UpdateDocumentHandler updateDocumentHandler;
    private MongoOperations mongoTemplate;

    @Before
    public void setup() {
        this.updateDocumentHandler = new UpdateDocumentHandler();
        this.mongoTemplate = (MongoOperations)EasyMock.createMock(MongoOperations.class);
    }

    @Test
    public void testHandlesUpdateDocuments() throws Exception {
        String testJson = "{ \"changeType\": \"updateDocuments\",\"collectionName\": \"collection\",\"query\": {},\"document\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should handle updateDocument element", (Object)true, (Object)this.updateDocumentHandler.handlesChange(testNode));
    }

    @Test
    public void testDoesNotHandleAddDocument() throws Exception {
        String testJson = "{ \"changeType\": \"addDocument\",\"collectionName\": \"collection\",\"query\": {},\"document\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should not handle addDocument element", (Object)false, (Object)this.updateDocumentHandler.handlesChange(testNode));
    }

    @Test
    public void testMakeChangeUpdatesDocument() throws Exception {
        Query q = new Query(Criteria.where((String)"myId").is((Object)"10"));
        this.mongoTemplate.remove(q, "collection");
        EasyMock.expectLastCall();
        this.mongoTemplate.save(JSON.parse((String)"{ }"), "collection");
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mongoTemplate});
        this.updateDocumentHandler.setMongoTemplate(this.mongoTemplate);
        String testJson = "{ \"changeType\": \"updateDocuments\",\"collectionName\": \"collection\",\"query\": { \"myId\": \"10\" },\"document\": {} }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        this.updateDocumentHandler.makeChange(testNode);
        EasyMock.verify((Object[])new Object[]{this.mongoTemplate});
    }

    @Test
    public void testMissingFieldGivesGoodError() throws Exception {
        String testJson = "{ \"changeType\": \"addDocument\",\"query\": {},\"document\": { \"myId\": \"10\"} }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        try {
            this.updateDocumentHandler.makeChange(testNode);
            Assert.fail((String)"Method should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

