/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.sys.datatools.liquimongo.change.UpdateNodeHandler;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class UpdateNodeHandlerTest {
    private UpdateNodeHandler updateNodeHandler;
    private MongoOperations mongoTemplate;

    @Before
    public void setup() {
        this.updateNodeHandler = new UpdateNodeHandler();
        this.mongoTemplate = (MongoOperations)EasyMock.createMock(MongoOperations.class);
    }

    @Test
    public void testHandlesUpdateNodes() throws Exception {
        String testJson = "{ \"changeType\": \"updateNode\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should handle updateNode element", (Object)true, (Object)this.updateNodeHandler.handlesChange(testNode));
    }

    @Test
    public void testDoesNotHandleDeleteDocument() throws Exception {
        String testJson = "{ \"changeType\": \"deleteDocument\",\"collectionName\": \"collection\",\"query\": { } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        Assert.assertEquals((String)"Should not handle deleteDocument element", (Object)false, (Object)this.updateNodeHandler.handlesChange(testNode));
    }

    @Test
    public void testMakeChangeUpdateNode() throws Exception {
        Query q = new Query(Criteria.where((String)"myId").is((Object)"10"));
        EasyMock.expect((Object)this.mongoTemplate.findOne(q, DBObject.class, "collection")).andReturn((Object)this.createSampleDocumentBeforeUpdate());
        this.mongoTemplate.remove(q, "collection");
        EasyMock.expectLastCall();
        this.mongoTemplate.save((Object)this.createSampleDocumentAfterUpdate(), "collection");
        EasyMock.replay((Object[])new Object[]{this.mongoTemplate});
        String testJson = "{ \"changeType\": \"updateNode\",\"collectionName\": \"collection\",\"query\": { \"myId\": \"10\"},\"path\": \"$..link[?(@.label=='Label5')]\",\"value\": { \"label\" : \"Label6\"}  }";
        this.updateNodeHandler.setMongoTemplate(this.mongoTemplate);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        this.updateNodeHandler.makeChange(testNode);
        EasyMock.verify((Object[])new Object[]{this.mongoTemplate});
    }

    @Test
    public void testMakeChangeUpdateLabel() throws Exception {
        Query q = new Query(Criteria.where((String)"myId").is((Object)"10"));
        EasyMock.expect((Object)this.mongoTemplate.findOne(q, DBObject.class, "collection")).andReturn((Object)this.createSampleDocumentBeforeUpdate());
        this.mongoTemplate.remove(q, "collection");
        EasyMock.expectLastCall();
        this.mongoTemplate.save((Object)this.createSampleDocumentAfterUpdate(), "collection");
        EasyMock.replay((Object[])new Object[]{this.mongoTemplate});
        String testJson = "{ \"changeType\": \"updateNode\",\"collectionName\": \"collection\",\"query\": { \"myId\": \"10\"},\"path\": \"$..link[?(@.label=='Label5')].label\",\"value\": \"Label6\" }";
        this.updateNodeHandler.setMongoTemplate(this.mongoTemplate);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode testNode = (JsonNode)mapper.readValue(testJson, JsonNode.class);
        this.updateNodeHandler.makeChange(testNode);
        EasyMock.verify((Object[])new Object[]{this.mongoTemplate});
    }

    private DBObject createSampleDocumentBeforeUpdate() {
        return (DBObject)JSON.parse((String)"{ \"link\": [{\"label\": \"Label1\"}, {\"label\": \"Label5\"}, {\"label\": \"Label2\"}] }");
    }

    private DBObject createSampleDocumentAfterUpdate() {
        return (DBObject)JSON.parse((String)"{ \"link\": [{\"label\": \"Label1\"}, {\"label\": \"Label6\"}, {\"label\": \"Label2\"}] }");
    }
}

