/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.sys.datatools.service;

import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.sys.datatools.liquimongo.dataaccess.DocumentStoreUpdateProcessDao;
import org.kuali.kfs.sys.datatools.liquimongo.service.impl.DocumentStoreSchemaUpdateServiceImpl;
import org.kuali.kfs.sys.datatools.mock.MockDocumentStoreChangeHandler;
import org.kuali.kfs.sys.datatools.mock.MockDocumentStoreUpdateProcessDao;

public class DocumentStoreSchemaUpdateServiceTest {
    private DocumentStoreSchemaUpdateServiceImpl documentStoreSchemaUpdateService;
    private MockDocumentStoreUpdateProcessDao mockMongoUpdateProcessDao;
    private MockDocumentStoreChangeHandler mongoChangeHandler;

    @Before
    public void setupMongoSchemaUpdateStep() {
        this.mongoChangeHandler = new MockDocumentStoreChangeHandler();
        ArrayList<MockDocumentStoreChangeHandler> handlers = new ArrayList<MockDocumentStoreChangeHandler>();
        handlers.add(this.mongoChangeHandler);
        this.mockMongoUpdateProcessDao = new MockDocumentStoreUpdateProcessDao();
        this.documentStoreSchemaUpdateService = new DocumentStoreSchemaUpdateServiceImpl();
        this.documentStoreSchemaUpdateService.setUpdatesPath("classpath:org/kuali/kfs/sys/datatools/liquimongo/batch/fixture/documentstoreschemaupdate/");
        this.documentStoreSchemaUpdateService.setDocumentStoreUpdateProcessDao((DocumentStoreUpdateProcessDao)this.mockMongoUpdateProcessDao);
        this.documentStoreSchemaUpdateService.setHandlers(handlers);
    }

    @Test
    public void testMissingUpdatesFile() throws Exception {
        this.documentStoreSchemaUpdateService.setUpdatesList("updatesXXX.json");
        try {
            this.documentStoreSchemaUpdateService.updateDocumentStoreSchema();
            Assert.fail((String)"Job should not run successfully");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOneFile() throws Exception {
        this.documentStoreSchemaUpdateService.setUpdatesList("updates1.json");
        this.documentStoreSchemaUpdateService.updateDocumentStoreSchema();
        Assert.assertEquals((String)"3 change made", (int)3, (int)this.mongoChangeHandler.changesMade);
    }

    @Test
    public void testTwoFiles() throws Exception {
        this.documentStoreSchemaUpdateService.setUpdatesList("updates2.json");
        this.documentStoreSchemaUpdateService.updateDocumentStoreSchema();
        Assert.assertEquals((String)"6 change made", (int)6, (int)this.mongoChangeHandler.changesMade);
    }

    @Test
    public void testRunsOnTrueStartupProperty() throws Exception {
        this.documentStoreSchemaUpdateService.setUpdatesList("updates1.json");
        this.documentStoreSchemaUpdateService.updateDocumentStoreSchema();
        Assert.assertEquals((String)"3 change made", (int)3, (int)this.mongoChangeHandler.changesMade);
    }

    @Test
    public void testDoesNotRunsIfLocked() throws Exception {
        this.documentStoreSchemaUpdateService.setUpdatesList("updates1.json");
        this.mockMongoUpdateProcessDao.lockSchemaChange();
        this.documentStoreSchemaUpdateService.updateDocumentStoreSchema();
        Assert.assertEquals((String)"0 changes made", (int)0, (int)this.mongoChangeHandler.changesMade);
    }

    @Test
    public void testUnlocksAfterRun() throws Exception {
        this.documentStoreSchemaUpdateService.setUpdatesList("updates1.json");
        this.mockMongoUpdateProcessDao.unlockSchemaChange();
        this.documentStoreSchemaUpdateService.updateDocumentStoreSchema();
        Assert.assertEquals((String)"3 changes made", (int)3, (int)this.mongoChangeHandler.changesMade);
        Assert.assertEquals((String)"Lock should be unset after run", (boolean)false, (boolean)this.mockMongoUpdateProcessDao.isSchemaChangeLocked());
    }
}

