/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.businessobject;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.sys.businessobject.AccountingLineOverride;

public class EffortCertificationDetailLineOverride {
    public static final List<String> REFRESH_FIELDS = Arrays.asList("account");

    public static void populateFromInput(EffortCertificationDetail detailLine) {
        HashSet<Integer> overrideInputComponents = new HashSet<Integer>();
        if (detailLine.isAccountExpiredOverride()) {
            overrideInputComponents.add(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT);
        }
        Integer[] inputComponentArray = overrideInputComponents.toArray(new Integer[overrideInputComponents.size()]);
        detailLine.setOverrideCode(AccountingLineOverride.valueOf((Integer[])inputComponentArray).getCode());
    }

    public static void processForOutput(EffortCertificationDetail detailLine) {
        AccountingLineOverride fromCurrentCode = AccountingLineOverride.valueOf((String)detailLine.getOverrideCode());
        AccountingLineOverride needed = EffortCertificationDetailLineOverride.determineNeededOverrides(detailLine);
        detailLine.setAccountExpiredOverride(fromCurrentCode.hasComponent(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT));
        detailLine.setAccountExpiredOverrideNeeded(needed.hasComponent(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT));
    }

    public static AccountingLineOverride determineNeededOverrides(EffortCertificationDetail detailLine) {
        HashSet<Integer> neededOverrideComponents = new HashSet<Integer>();
        if (AccountingLineOverride.needsExpiredAccountOverride((Account)detailLine.getAccount())) {
            neededOverrideComponents.add(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT);
        }
        Integer[] inputComponentArray = neededOverrideComponents.toArray(new Integer[neededOverrideComponents.size()]);
        return AccountingLineOverride.valueOf((Integer[])inputComponentArray);
    }
}

