/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.authorization;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentAuthorizerBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public class EffortCertificationDocumentAuthorizer
extends FinancialSystemTransactionalDocumentAuthorizerBase {
    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActionsFromPresentationController) {
        Set documentActionsToReturn = super.getDocumentActions(document, user, documentActionsFromPresentationController);
        UserSession userSession = GlobalVariables.getUserSession();
        String principalId = userSession.getPrincipalId();
        if (document.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            Set<Person> priorApprovers = this.getPriorApprovers(document.getDocumentHeader().getWorkflowDocument());
            for (Person priorApprover : priorApprovers) {
                if (!principalId.equals(priorApprover.getPrincipalId())) continue;
                documentActionsToReturn.add("canEdit");
                documentActionsToReturn.add("canSave");
            }
        }
        return documentActionsToReturn;
    }

    protected Set<Person> getPriorApprovers(WorkflowDocument workflowDocument) {
        PersonService personService = KimApiServiceLocator.getPersonService();
        List actionsTaken = workflowDocument.getActionsTaken();
        HashSet<String> principalIds = new HashSet<String>();
        HashSet<Person> persons = new HashSet<Person>();
        for (ActionTaken actionTaken : actionsTaken) {
            String principalId;
            if (!"A".equals(actionTaken.getActionTaken().getCode()) || principalIds.contains(principalId = actionTaken.getPrincipalId())) continue;
            principalIds.add(principalId);
            persons.add(personService.getPerson(principalId));
        }
        return persons;
    }

    public boolean doPermissionExistsByTemplate(BusinessObject businessObject, String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails) {
        return this.permissionExistsByTemplate(businessObject, namespaceCode, permissionTemplateName, permissionDetails);
    }
}

