/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ec.EffortCertificationModuleService;
import org.kuali.kfs.integration.ec.EffortCertificationReport;
import org.kuali.kfs.module.ec.EffortConstants;
import org.kuali.kfs.module.ec.dataaccess.EffortCertificationReportDefinitionDao;
import org.kuali.kfs.module.ec.service.EffortCertificationReportDefinitionService;
import org.kuali.kfs.module.ec.util.AccountingPeriodMonth;
import org.kuali.kfs.sys.context.SpringContext;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationModuleServiceImpl
implements EffortCertificationModuleService {
    public List<EffortCertificationReport> findReportDefinitionsForPeriod(Integer fiscalYear, String periodCode, String positionObjectGroupCode) {
        List<EffortCertificationReport> effortCertificationReports = this.getEffortCertificationReportDefinitionDao().getAllByYearAndPositionCode(fiscalYear, positionObjectGroupCode);
        ArrayList<EffortCertificationReport> reportsContainingPeriod = new ArrayList<EffortCertificationReport>();
        for (EffortCertificationReport report : effortCertificationReports) {
            Map<Integer, Set<String>> reportPeriods = AccountingPeriodMonth.findAccountingPeriodsBetween(report.getEffortCertificationReportBeginFiscalYear(), report.getEffortCertificationReportBeginPeriodCode(), report.getEffortCertificationReportEndFiscalYear(), report.getEffortCertificationReportEndPeriodCode());
            Set<String> periodsForYear = reportPeriods.get(fiscalYear);
            if (!periodsForYear.contains(periodCode)) continue;
            reportsContainingPeriod.add(report);
        }
        return reportsContainingPeriod;
    }

    public EffortCertificationReport isEmployeeWithOpenCertification(List<EffortCertificationReport> effortCertificationReports, String emplid) {
        for (EffortCertificationReport report : effortCertificationReports) {
            if (!this.getEffortCertificationReportDefinitionService().hasBeenUsedForEffortCertificationGeneration(emplid, report)) continue;
            return report;
        }
        return null;
    }

    public List<String> getCostShareSubAccountTypeCodes() {
        return EffortConstants.ELIGIBLE_COST_SHARE_SUB_ACCOUNT_TYPE_CODES;
    }

    public EffortCertificationReportDefinitionService getEffortCertificationReportDefinitionService() {
        return (EffortCertificationReportDefinitionService)SpringContext.getBean(EffortCertificationReportDefinitionService.class);
    }

    public EffortCertificationReportDefinitionDao getEffortCertificationReportDefinitionDao() {
        return (EffortCertificationReportDefinitionDao)SpringContext.getBean(EffortCertificationReportDefinitionDao.class);
    }

    public ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }
}

