/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.integration.ld.LaborLedgerEntry;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentService;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.kfs)
public class EffortCertificationDocumentServiceTest
extends KualiTestBase {
    private final Properties properties;
    private final Properties message;
    private final String balanceFieldNames;
    private final String entryFieldNames;
    private final String detailFieldNames;
    private final String documentFieldNames;
    private final String reportDefinitionFieldNames;
    private final String deliminator;
    private BusinessObjectService businessObjectService;
    private EffortCertificationDocumentService effortCertificationDocumentService;
    private LaborModuleService laborModuleService;
    private Class<? extends LaborLedgerBalance> ledgerBalanceClass;
    private Class<? extends LaborLedgerEntry> ledgerEntryClass;

    public EffortCertificationDocumentServiceTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationDocumentService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.balanceFieldNames = this.properties.getProperty("balanceFieldNames");
        this.entryFieldNames = this.properties.getProperty("entryFieldNames");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.documentFieldNames = this.properties.getProperty("documentFieldNames");
        this.reportDefinitionFieldNames = this.properties.getProperty("reportDefinitionFieldNames");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.effortCertificationDocumentService = (EffortCertificationDocumentService)SpringContext.getBean(EffortCertificationDocumentService.class);
        this.laborModuleService = (LaborModuleService)SpringContext.getBean(LaborModuleService.class);
        KualiModuleService kualiModuleService = (KualiModuleService)SpringContext.getBean(KualiModuleService.class);
        this.ledgerBalanceClass = LedgerBalance.class;
        this.ledgerEntryClass = ((LaborLedgerEntry)kualiModuleService.getResponsibleModuleService(LaborLedgerEntry.class).createNewObjectFromExternalizableClass(LaborLedgerEntry.class)).getClass();
    }

    public void testCreateEffortCertificationDocument() throws Exception {
        String testTarget = "createEffortCertificationDocument.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("");
        reportDefinition = (EffortCertificationReportDefinition)TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        EffortCertificationDocumentBuild documentBuild = this.buildDocumentBuild(testTarget);
        documentBuild = (EffortCertificationDocumentBuild)TestDataPreparator.persistDataObject((PersistableBusinessObject)documentBuild);
        try {
            boolean isCreated = this.effortCertificationDocumentService.createAndRouteEffortCertificationDocument(documentBuild);
            EffortCertificationDocumentServiceTest.assertTrue((boolean)isCreated);
        }
        catch (ValidationException ex) {
            EffortCertificationDocumentServiceTest.fail((String)("Business Rule Failure: " + GlobalVariables.getMessageMap()));
        }
        List documentList = TestDataPreparator.findMatching(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.valueOf(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        List expectedDocuments = TestDataPreparator.buildExpectedValueList(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "expectedDocument"), (String)this.documentFieldNames, (String)this.deliminator, (int)numberOfExpectedDocuments);
        EffortCertificationDocumentServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentList.size());
        List documentKeyFields = ObjectUtil.split((String)this.documentFieldNames, (String)this.deliminator);
        documentKeyFields.remove("documentNumber");
        EffortCertificationDocumentServiceTest.assertTrue((boolean)TestDataPreparator.hasSameElements((List)expectedDocuments, (List)documentList, (List)documentKeyFields));
        for (EffortCertificationDocument document : documentList) {
            EffortCertificationDocumentServiceTest.assertEquals((String)"R", (String)document.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode());
        }
    }

    public void testGenerateSalaryExpenseTransferDocument() throws Exception {
        String testTarget = "generateSalaryExpenseTransferDocument.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadLaborTestData(testTarget);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("");
        reportDefinition = (EffortCertificationReportDefinition)TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        EffortCertificationDocumentBuild documentBuild = this.buildDocumentBuild(testTarget);
        documentBuild = (EffortCertificationDocumentBuild)TestDataPreparator.persistDataObject((PersistableBusinessObject)documentBuild);
        try {
            boolean isCreated = this.effortCertificationDocumentService.createAndRouteEffortCertificationDocument(documentBuild);
            EffortCertificationDocumentServiceTest.assertTrue((boolean)isCreated);
        }
        catch (ValidationException ex) {
            EffortCertificationDocumentServiceTest.fail((String)("Business Rule Failure: " + GlobalVariables.getMessageMap()));
        }
        List documentList = TestDataPreparator.findMatching(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        for (EffortCertificationDocument document : documentList) {
            document.refreshReferenceObject("effortCertificationReportDefinition");
            boolean isGenerated = this.effortCertificationDocumentService.generateSalaryExpenseTransferDocument(document);
            EffortCertificationDocumentServiceTest.assertTrue((String)"The document should be generated and approved.", (boolean)isGenerated);
        }
    }

    private EffortCertificationReportDefinition buildReportDefinition(String testTarget) {
        return (EffortCertificationReportDefinition)TestDataPreparator.buildTestDataObject(EffortCertificationReportDefinition.class, (Properties)this.properties, (String)(testTarget + "reportDefinitionFieldValues"), (String)this.reportDefinitionFieldNames, (String)this.deliminator);
    }

    private EffortCertificationDocumentBuild buildDocumentBuild(String testTarget) {
        EffortCertificationDocumentBuild documentBuild = (EffortCertificationDocumentBuild)TestDataPreparator.buildTestDataObject(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentBuild"), (String)this.documentFieldNames, (String)this.deliminator);
        List<EffortCertificationDetailBuild> detailBuild = this.buildDetailLineBuild(testTarget);
        documentBuild.setEffortCertificationDetailLinesBuild(detailBuild);
        return documentBuild;
    }

    private List<EffortCertificationDetailBuild> buildDetailLineBuild(String testTarget) {
        int numberOfDetailBuild = Integer.valueOf(this.properties.getProperty(testTarget + "numOfDetailBuilds"));
        return TestDataPreparator.buildTestDataList(EffortCertificationDetailBuild.class, (Properties)this.properties, (String)(testTarget + "detailBuild"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetailBuild);
    }

    private void loadLaborTestData(String testTarget) throws Exception {
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerEntryClass, (Properties)this.properties, (String)(testTarget + "dataCleanup"), (String)this.entryFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "dataCleanup"), (String)this.balanceFieldNames, (String)this.deliminator);
        int numberOfEntries = Integer.valueOf(this.properties.getProperty(testTarget + "numOfEntries"));
        List ledgerEntries = TestDataPreparator.buildTestDataList(this.ledgerEntryClass, (Properties)this.properties, (String)(testTarget + "inputEntry"), (String)this.entryFieldNames, (String)this.deliminator, (int)numberOfEntries);
        TestDataPreparator.persistDataObject((List)ledgerEntries);
        int numberOfBalances = Integer.valueOf(this.properties.getProperty(testTarget + "numOfBalances"));
        List ledgerBalances = TestDataPreparator.buildTestDataList(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator, (int)numberOfBalances);
        TestDataPreparator.persistDataObject((List)ledgerBalances);
    }
}

