/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.kuali.kfs.module.ec.util.AccountingPeriodMonth;

public class AccountingPeriodMonthTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testFindAccountingPeriod() throws Exception {
        AccountingPeriodMonth month1 = AccountingPeriodMonth.findAccountingPeriod((String)AccountingPeriodMonth.MONTH1.periodCode);
        AccountingPeriodMonthTest.assertEquals((Object)AccountingPeriodMonth.MONTH1, (Object)month1);
        AccountingPeriodMonth month12 = AccountingPeriodMonth.findAccountingPeriod((String)AccountingPeriodMonth.MONTH12.periodCode);
        AccountingPeriodMonthTest.assertEquals((Object)AccountingPeriodMonth.MONTH12, (Object)month12);
        AccountingPeriodMonth month6 = AccountingPeriodMonth.findAccountingPeriod((String)AccountingPeriodMonth.MONTH6.periodCode);
        AccountingPeriodMonthTest.assertEquals((Object)AccountingPeriodMonth.MONTH6, (Object)month6);
        AccountingPeriodMonthTest.assertFalse((AccountingPeriodMonth.MONTH1.compareTo((Enum)month6) == 0 ? 1 : 0) != 0);
        AccountingPeriodMonthTest.assertFalse((AccountingPeriodMonth.MONTH12.compareTo((Enum)month6) == 0 ? 1 : 0) != 0);
        AccountingPeriodMonth unknownMonth = AccountingPeriodMonth.findAccountingPeriod((String)"UNKNOWN");
        AccountingPeriodMonthTest.assertNull((Object)unknownMonth);
        AccountingPeriodMonth emptyMonth = AccountingPeriodMonth.findAccountingPeriod((String)"");
        AccountingPeriodMonthTest.assertNull((Object)emptyMonth);
    }

    public void testFindAccountingPeriodsBetween_WithinSameYear() throws Exception {
        Integer year = 2008;
        this.assertAccountingPeriodsWithinYear(year, AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH12);
        this.assertAccountingPeriodsWithinYear(year, AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH3);
        this.assertAccountingPeriodsWithinYear(year, AccountingPeriodMonth.MONTH4, AccountingPeriodMonth.MONTH8);
        this.assertAccountingPeriodsWithinYear(year, AccountingPeriodMonth.MONTH9, AccountingPeriodMonth.MONTH12);
        try {
            this.assertAccountingPeriodsWithinYear(year, AccountingPeriodMonth.MONTH9, AccountingPeriodMonth.MONTH5);
            AccountingPeriodMonthTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFindAccountingPeriodsBetween_AcrossMultipleYears() throws Exception {
        Integer beginYear = 2008;
        Integer endYear = 2010;
        this.assertAccountingPeriodsAcrossYears(beginYear, AccountingPeriodMonth.MONTH1, endYear, AccountingPeriodMonth.MONTH12);
        this.assertAccountingPeriodsAcrossYears(beginYear, AccountingPeriodMonth.MONTH1, endYear, AccountingPeriodMonth.MONTH4);
        this.assertAccountingPeriodsAcrossYears(beginYear, AccountingPeriodMonth.MONTH5, endYear, AccountingPeriodMonth.MONTH12);
        this.assertAccountingPeriodsAcrossYears(beginYear, AccountingPeriodMonth.MONTH5, endYear, AccountingPeriodMonth.MONTH4);
        try {
            this.assertAccountingPeriodsAcrossYears(endYear, AccountingPeriodMonth.MONTH5, beginYear, AccountingPeriodMonth.MONTH4);
            AccountingPeriodMonthTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuildPeriodCodeSetWithinRange() throws Exception {
        this.assertAccountingPeriodsWithinRange(AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH12);
        this.assertAccountingPeriodsWithinRange(AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH3);
        this.assertAccountingPeriodsWithinRange(AccountingPeriodMonth.MONTH4, AccountingPeriodMonth.MONTH8);
        this.assertAccountingPeriodsWithinRange(AccountingPeriodMonth.MONTH9, AccountingPeriodMonth.MONTH12);
        try {
            this.assertAccountingPeriodsWithinRange(AccountingPeriodMonth.MONTH9, AccountingPeriodMonth.MONTH5);
            AccountingPeriodMonthTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertAccountingPeriodsWithinYear(Integer year, AccountingPeriodMonth beginPeriod, AccountingPeriodMonth endPeriod) {
        Map periods = AccountingPeriodMonth.findAccountingPeriodsBetween((Integer)year, (String)beginPeriod.periodCode, (Integer)year, (String)endPeriod.periodCode);
        Set periodCodes = (Set)periods.get(year);
        this.assertAccountingPeriodMonthEqual(periodCodes, beginPeriod, endPeriod);
    }

    private void assertAccountingPeriodsWithinRange(AccountingPeriodMonth beginPeriod, AccountingPeriodMonth endPeriod) {
        Set periodCodes = AccountingPeriodMonth.buildPeriodCodeSetWithinRange((AccountingPeriodMonth)beginPeriod, (AccountingPeriodMonth)endPeriod);
        this.assertAccountingPeriodMonthEqual(periodCodes, beginPeriod, endPeriod);
    }

    private void assertAccountingPeriodsAcrossYears(Integer beginYear, AccountingPeriodMonth beginPeriod, Integer endYear, AccountingPeriodMonth endPeriod) {
        Map periods = AccountingPeriodMonth.findAccountingPeriodsBetween((Integer)beginYear, (String)beginPeriod.periodCode, (Integer)endYear, (String)endPeriod.periodCode);
        Set beginPeriodCodes = (Set)periods.get(beginYear);
        this.assertAccountingPeriodMonthEqual(beginPeriodCodes, beginPeriod, AccountingPeriodMonth.MONTH13);
        for (int year = beginYear + 1; year <= endYear - 1; ++year) {
            Set periodCodes = (Set)periods.get(year);
            this.assertAccountingPeriodMonthEqual(periodCodes, AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH13);
        }
        Set endPeriodCodes = (Set)periods.get(endYear);
        this.assertAccountingPeriodMonthEqual(endPeriodCodes, AccountingPeriodMonth.MONTH1, endPeriod);
    }

    private void assertAccountingPeriodMonthEqual(Set<String> periodCodes, AccountingPeriodMonth beginPeriod, AccountingPeriodMonth endPeriod) {
        EnumSet<AccountingPeriodMonth> accountingPeriodMonth = EnumSet.range(beginPeriod, endPeriod);
        AccountingPeriodMonthTest.assertTrue((periodCodes.size() == accountingPeriodMonth.size() ? 1 : 0) != 0);
        for (String code : periodCodes) {
            AccountingPeriodMonth month = AccountingPeriodMonth.findAccountingPeriod((String)code);
            AccountingPeriodMonthTest.assertTrue((boolean)accountingPeriodMonth.contains(month));
        }
    }
}

