/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.batch.service.impl;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ec.batch.service.EffortCertificationCreateService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentService;
import org.kuali.kfs.module.ec.util.EffortCertificationParameterFinder;
import org.kuali.kfs.sys.MessageBuilder;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationCreateServiceImpl
implements EffortCertificationCreateService {
    private static Logger LOG = Logger.getLogger(EffortCertificationCreateServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private EffortCertificationDocumentService effortCertificationDocumentService;

    @Override
    public void create() {
        Integer fiscalYear = EffortCertificationParameterFinder.getCreateReportFiscalYear();
        String reportNumber = EffortCertificationParameterFinder.getCreateReportNumber();
        this.create(fiscalYear, reportNumber);
    }

    @Override
    public void create(Integer fiscalYear, String reportNumber) {
        Map<String, String> fieldValues = EffortCertificationReportDefinition.buildKeyMap(fiscalYear, reportNumber);
        String errorMessage = this.validateReportDefintion(fieldValues);
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            LOG.fatal((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        Collection documentsBuild = this.businessObjectService.findMatching(EffortCertificationDocumentBuild.class, fieldValues);
        for (EffortCertificationDocumentBuild documentBuild : documentsBuild) {
            boolean isCreated = this.effortCertificationDocumentService.createAndRouteEffortCertificationDocument(documentBuild);
            if (!isCreated) continue;
            this.businessObjectService.delete((PersistableBusinessObject)documentBuild);
        }
    }

    protected String validateReportDefintion(Map<String, String> fieldValues) {
        String fiscalYear = fieldValues.get("universityFiscalYear");
        String reportNumber = fieldValues.get("effortCertificationReportNumber");
        String combinedFieldValues = fiscalYear + ", " + reportNumber;
        if (StringUtils.isEmpty((CharSequence)fiscalYear)) {
            return MessageBuilder.buildMessage((String)"error.effort.fiscalYearMissing", null).getMessage();
        }
        if (StringUtils.isEmpty((CharSequence)reportNumber)) {
            return MessageBuilder.buildMessage((String)"error.effort.reportNumberMissing", null).getMessage();
        }
        EffortCertificationReportDefinition reportDefinition = (EffortCertificationReportDefinition)this.businessObjectService.findByPrimaryKey(EffortCertificationReportDefinition.class, fieldValues);
        if (reportDefinition == null) {
            return MessageBuilder.buildMessage((String)"error.effort.fiscalYearOrReportNumberInvalid", (String)combinedFieldValues).getMessage();
        }
        if (!reportDefinition.isActive()) {
            return MessageBuilder.buildMessage((String)"error.effort.reportDefinitionInactive", (String)combinedFieldValues).getMessage();
        }
        if (!"O".equals(reportDefinition.getEffortCertificationReportPeriodStatusCode())) {
            return MessageBuilder.buildMessage((String)"error.effort.reportDefinitionPeriodNotOpened", (String)combinedFieldValues).getMessage();
        }
        int countOfDocuments = this.businessObjectService.countMatching(EffortCertificationDocument.class, fieldValues);
        if (countOfDocuments > 0) {
            return MessageBuilder.buildMessageWithPlaceHolder((String)"error.effort.reportDocumentExist", (Object[])new Object[]{reportNumber, fiscalYear}).getMessage();
        }
        int countOfDocumentsBuild = this.businessObjectService.countMatching(EffortCertificationDocumentBuild.class, fieldValues);
        if (countOfDocumentsBuild <= 0) {
            return MessageBuilder.buildMessageWithPlaceHolder((String)"error.effort.reportDocumentBuildNotExist", (Object[])new Object[]{reportNumber, fiscalYear}).getMessage();
        }
        return null;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setEffortCertificationDocumentService(EffortCertificationDocumentService effortCertificationDocumentService) {
        this.effortCertificationDocumentService = effortCertificationDocumentService;
    }
}

