/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.service.impl;

import java.util.List;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.dataaccess.EffortCertificationReportDefinitionDao;
import org.kuali.kfs.module.ec.document.service.EffortCertificationAutomaticReportPeriodUpdateService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationAutomaticReportPeriodUpdateServiceImpl
implements EffortCertificationAutomaticReportPeriodUpdateService {
    private EffortCertificationReportDefinitionDao reportDefinitionDao;

    @Override
    public List<EffortCertificationReportDefinition> getAllReportDefinitions() {
        return this.reportDefinitionDao.getAll();
    }

    @Override
    public boolean isAnOverlappingReportDefinition(EffortCertificationReportDefinition reportDefinition) {
        List<EffortCertificationReportDefinition> potentialOverlappingRecords = this.reportDefinitionDao.getAllOtherActiveByType(reportDefinition);
        for (EffortCertificationReportDefinition potentialOverlappingRecord : potentialOverlappingRecords) {
            if (!this.isOverlapping(potentialOverlappingRecord, reportDefinition)) continue;
            return true;
        }
        return false;
    }

    public EffortCertificationReportDefinitionDao getEffortCertificationReportDefinitionDao() {
        return this.reportDefinitionDao;
    }

    @Override
    public void setEffortCertificationReportDefinitionDao(EffortCertificationReportDefinitionDao effortCertificationReportDefinitionDao) {
        this.reportDefinitionDao = effortCertificationReportDefinitionDao;
    }

    protected boolean isOverlapping(EffortCertificationReportDefinition existingReportDefinition, EffortCertificationReportDefinition newReportDefiniton) {
        Integer existingStartYear = existingReportDefinition.getEffortCertificationReportBeginFiscalYear();
        String existingStartPeriod = existingReportDefinition.getEffortCertificationReportBeginPeriodCode();
        Integer existingEndYear = existingReportDefinition.getEffortCertificationReportEndFiscalYear();
        String existingEndPeriod = existingReportDefinition.getEffortCertificationReportEndPeriodCode();
        if (existingStartYear == null || existingStartPeriod == null || existingEndYear == null || existingEndPeriod == null) {
            return false;
        }
        Integer newStartYear = newReportDefiniton.getEffortCertificationReportBeginFiscalYear();
        String newStartPeriod = newReportDefiniton.getEffortCertificationReportBeginPeriodCode();
        Integer newEndYear = newReportDefiniton.getEffortCertificationReportEndFiscalYear();
        String newEndPeriod = newReportDefiniton.getEffortCertificationReportEndPeriodCode();
        boolean isNewStartPeriodWithin = this.isPeriodWithinRange(existingStartYear, existingStartPeriod, existingEndYear, existingEndPeriod, newStartYear, newStartPeriod);
        if (isNewStartPeriodWithin) {
            return true;
        }
        boolean isNewEndPeriodWithin = this.isPeriodWithinRange(existingStartYear, existingStartPeriod, existingEndYear, existingEndPeriod, newEndYear, newEndPeriod);
        if (isNewEndPeriodWithin) {
            return true;
        }
        boolean isExistingStartPeriodWithin = this.isPeriodWithinRange(newStartYear, newStartPeriod, newEndYear, newEndPeriod, existingStartYear, existingStartPeriod);
        if (isExistingStartPeriodWithin) {
            return true;
        }
        boolean isExistingEndPeriodWithin = this.isPeriodWithinRange(newStartYear, newStartPeriod, newEndYear, newEndPeriod, existingEndYear, existingEndPeriod);
        return isExistingEndPeriodWithin;
    }

    protected boolean isPeriodWithinRange(Integer startYear, String startPeriod, Integer endYear, String endPeriod, Integer year, String period) {
        return this.comparePeriod(startYear, startPeriod, year, period) <= 0 && this.comparePeriod(endYear, endPeriod, year, period) >= 0;
    }

    protected int comparePeriod(Integer year, String periodCode, Integer anotherYear, String anotherPeriodCode) {
        String period = year + periodCode;
        String anotherPeriod = anotherYear + anotherPeriodCode;
        return period.compareTo(anotherPeriod);
    }
}

