/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ec.EffortCertificationReport;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportEarnPaygroup;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportPosition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.service.EffortCertificationReportDefinitionService;
import org.kuali.kfs.sys.MessageBuilder;

public class EffortCertificationReportDefinitionServiceImpl
implements EffortCertificationReportDefinitionService {
    private static Logger LOG = Logger.getLogger(EffortCertificationReportDefinitionServiceImpl.class);
    private BusinessObjectService businessObjectService;

    @Override
    public EffortCertificationReportDefinition findReportDefinitionByPrimaryKey(Map<String, String> fieldValues) {
        return (EffortCertificationReportDefinition)this.businessObjectService.findByPrimaryKey(EffortCertificationReportDefinition.class, fieldValues);
    }

    @Override
    public String validateEffortCertificationReportDefinition(EffortCertificationReportDefinition effortCertificationReportDefinition) {
        Integer fiscalYear = effortCertificationReportDefinition.getUniversityFiscalYear();
        String reportNumber = effortCertificationReportDefinition.getEffortCertificationReportNumber();
        if (ObjectUtils.isNull((Object)fiscalYear)) {
            return MessageBuilder.buildMessage((String)"error.effort.fiscalYearMissing", null).getMessage();
        }
        if (StringUtils.isEmpty((CharSequence)reportNumber)) {
            return MessageBuilder.buildMessage((String)"error.effort.reportNumberMissing", null).getMessage();
        }
        String combinedFieldValues = fiscalYear.toString() + ", " + reportNumber;
        if ((effortCertificationReportDefinition = (EffortCertificationReportDefinition)this.businessObjectService.retrieve((PersistableBusinessObject)effortCertificationReportDefinition)) == null) {
            return MessageBuilder.buildMessage((String)"error.effort.reportDefinitionNotExist", (String)combinedFieldValues).getMessage();
        }
        if (!effortCertificationReportDefinition.isActive()) {
            return MessageBuilder.buildMessage((String)"error.effort.reportDefinitionInactive", (String)combinedFieldValues).getMessage();
        }
        return null;
    }

    @Override
    public List<String> findPositionObjectGroupCodes(EffortCertificationReportDefinition reportDefinition) {
        Map<String, String> fieldValues = reportDefinition.buildKeyMapForCurrentReportDefinition();
        fieldValues.put("active", Boolean.TRUE.toString());
        Collection reportPosition = this.businessObjectService.findMatching(EffortCertificationReportPosition.class, fieldValues);
        ArrayList<String> positionGroupCodes = new ArrayList<String>();
        for (EffortCertificationReportPosition position : reportPosition) {
            positionGroupCodes.add(position.getEffortCertificationReportPositionObjectGroupCode());
        }
        return positionGroupCodes;
    }

    @Override
    public Map<String, Set<String>> findReportEarnCodePayGroups(EffortCertificationReportDefinition reportDefinition) {
        Collection<EffortCertificationReportEarnPaygroup> reportEarnPay = this.findReportEarnPay(reportDefinition);
        HashMap<String, Set<String>> earnCodePayGroups = new HashMap<String, Set<String>>();
        for (EffortCertificationReportEarnPaygroup earnPay : reportEarnPay) {
            Set<String> earnCodeSet;
            String payGroup = earnPay.getPayGroup();
            String earnCode = earnPay.getEarnCode();
            if (earnCodePayGroups.containsKey(payGroup)) {
                earnCodeSet = (Set)earnCodePayGroups.get(payGroup);
                earnCodeSet.add(earnCode);
                continue;
            }
            earnCodeSet = new HashSet();
            earnCodeSet.add(earnCode);
            earnCodePayGroups.put(payGroup, earnCodeSet);
        }
        return earnCodePayGroups;
    }

    @Override
    public Collection<EffortCertificationReportEarnPaygroup> findReportEarnPay(EffortCertificationReportDefinition reportDefinition) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", reportDefinition.getUniversityFiscalYear());
        fieldValues.put("effortCertificationReportTypeCode", reportDefinition.getEffortCertificationReportTypeCode());
        fieldValues.put("active", Boolean.TRUE.toString());
        return this.businessObjectService.findMatching(EffortCertificationReportEarnPaygroup.class, fieldValues);
    }

    @Override
    public boolean hasPendingEffortCertification(String emplid, EffortCertificationReportDefinition reportDefinition) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", reportDefinition.getUniversityFiscalYear());
        fieldValues.put("effortCertificationReportNumber", reportDefinition.getEffortCertificationReportNumber());
        int numOfPendingDocuments = this.businessObjectService.countMatching(EffortCertificationDocumentBuild.class, fieldValues);
        if (numOfPendingDocuments > 0) {
            return true;
        }
        List<String> pendingStatusCodes = Arrays.asList("R");
        fieldValues.put("emplid", emplid);
        fieldValues.put("documentHeader.financialDocumentStatusCode", pendingStatusCodes);
        return this.businessObjectService.countMatching(EffortCertificationDocument.class, fieldValues) > 0;
    }

    @Override
    public boolean hasApprovedEffortCertification(String emplid, EffortCertificationReportDefinition reportDefinition) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", reportDefinition.getUniversityFiscalYear());
        fieldValues.put("effortCertificationReportNumber", reportDefinition.getEffortCertificationReportNumber());
        fieldValues.put("emplid", emplid);
        fieldValues.put("documentHeader.financialDocumentStatusCode", "A");
        return this.businessObjectService.countMatching(EffortCertificationDocument.class, fieldValues) > 0;
    }

    @Override
    public boolean hasBeenUsedForEffortCertificationGeneration(EffortCertificationReportDefinition reportDefinition) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", reportDefinition.getUniversityFiscalYear());
        fieldValues.put("effortCertificationReportNumber", reportDefinition.getEffortCertificationReportNumber());
        return this.businessObjectService.countMatching(EffortCertificationDocument.class, fieldValues) > 0;
    }

    @Override
    public boolean hasBeenUsedForEffortCertificationGeneration(String emplid, EffortCertificationReport reportDefinition) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", reportDefinition.getUniversityFiscalYear());
        fieldValues.put("effortCertificationReportNumber", reportDefinition.getEffortCertificationReportNumber());
        fieldValues.put("emplid", emplid);
        return this.businessObjectService.countMatching(EffortCertificationDocument.class, fieldValues) > 0;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

