/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class EffortCertificationDocumentTest {
    private Properties properties;
    private String detailFieldNames;
    private String documentFieldNames;
    private String deliminator;

    @Before
    public void setUp() {
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationDocument.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.documentFieldNames = this.properties.getProperty("documentFieldNames");
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        DocumentHeaderService docHeaderSvcMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
        Mockito.when((Object)KRADServiceLocatorWeb.getDocumentHeaderService()).thenReturn((Object)docHeaderSvcMock);
        Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
        Mockito.when((Object)docHeaderSvcMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
    }

    @Test
    public void testGetEffortCertificationDetailWithMaxPayrollAmount_MultipleResults() {
        String testTarget = "getEffortCertificationDetailWithMaxPayrollAmount.multipleResults.";
        EffortCertificationDocument document = this.buildDocument(testTarget);
        List detailLineWithMaxPayrollAmount = document.getEffortCertificationDetailWithMaxPayrollAmount();
        int numberOfExpectedDetail = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedDetail")));
        Assert.assertEquals((long)numberOfExpectedDetail, (long)detailLineWithMaxPayrollAmount.size());
    }

    @Test
    public void testGetEffortCertificationDetailWithMaxPayrollAmount_SingleResult() {
        String testTarget = "getEffortCertificationDetailWithMaxPayrollAmount.singleResult.";
        EffortCertificationDocument document = this.buildDocument(testTarget);
        List detailLineWithMaxPayrollAmount = document.getEffortCertificationDetailWithMaxPayrollAmount();
        int numberOfExpectedDetail = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedDetail")));
        Assert.assertEquals((long)numberOfExpectedDetail, (long)detailLineWithMaxPayrollAmount.size());
    }

    private EffortCertificationDocument buildDocument(String testTarget) {
        EffortCertificationDocument document = (EffortCertificationDocument)TestDataPreparator.buildTestDataObject(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "document"), (String)this.documentFieldNames, (String)this.deliminator);
        List<EffortCertificationDetail> detailLines = this.buildDetailLine(testTarget);
        document.setEffortCertificationDetailLines(detailLines);
        return document;
    }

    private List<EffortCertificationDetail> buildDetailLine(String testTarget) {
        int numberOfDetail = Integer.parseInt(this.properties.getProperty(testTarget + "numOfDetail"));
        return TestDataPreparator.buildTestDataList(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + "detail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetail);
    }
}

