/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ec.util.DetailLineGroup;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;

@Execution(value=ExecutionMode.SAME_THREAD)
public class DetailLineGroupTest {
    private Properties properties;
    private String detailFieldNames;
    private String deliminator;

    @Before
    public void setUp() {
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/detailLineGroup.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
    }

    @Test
    public void detailLineGroupConstructor_WithOneParameter() {
        String testTarget = "constructor.withOneParameter.";
        EffortCertificationDetail detailLine = this.buildDetailLine(testTarget, "detail");
        DetailLineGroup detailLineGroupMap = new DetailLineGroup(detailLine);
        EffortCertificationDetail expectedSummaryLine = this.buildDetailLine(testTarget, "expectedSummaryLine");
        EffortCertificationDetail expectedDelegateLine = this.buildDetailLine(testTarget, "expectedDelegateLine");
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        Assert.assertTrue((boolean)ObjectUtil.equals((Object)expectedSummaryLine, (Object)detailLineGroupMap.getSummaryDetailLine(), (List)keyFields));
        Assert.assertTrue((boolean)ObjectUtil.equals((Object)expectedDelegateLine, (Object)detailLineGroupMap.getDelegateDetailLine(), (List)keyFields));
    }

    @Test
    public void updateDelegateDetailLineEffort() {
        String testTarget = "updateDelegateDetailLineEffort.";
        EffortCertificationDetail detailLine = this.buildDetailLine(testTarget, "detail");
        DetailLineGroup detailLineGroupMap = new DetailLineGroup(detailLine);
        String newEffortAsString = StringUtils.trim((String)this.properties.getProperty(testTarget + "newEffortPercent"));
        Integer newEffort = Integer.parseInt(newEffortAsString);
        detailLineGroupMap.getSummaryDetailLine().setEffortCertificationUpdatedOverallPercent(newEffort);
        detailLineGroupMap.updateDelegateDetailLineEffort();
        EffortCertificationDetail expectedSummaryLine = this.buildDetailLine(testTarget, "expectedSummaryLine");
        EffortCertificationDetail expectedDelegateLine = this.buildDetailLine(testTarget, "expectedDelegateLine");
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        Assert.assertTrue((boolean)ObjectUtil.equals((Object)expectedSummaryLine, (Object)detailLineGroupMap.getSummaryDetailLine(), (List)keyFields));
        Assert.assertTrue((boolean)ObjectUtil.equals((Object)expectedDelegateLine, (Object)detailLineGroupMap.getDelegateDetailLine(), (List)keyFields));
    }

    @Test
    public void groupDetailLines_SingleGroup() {
        String testTarget = "groupDetailLines.singleGroup.";
        int numberOfDetails = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfDetails")));
        List<EffortCertificationDetail> detailLines = this.buildDetailLines(testTarget, "detail", numberOfDetails);
        Map detailLineGroupMap = DetailLineGroup.groupDetailLines(detailLines);
        int numOfExpectedGroups = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedGroups")));
        Assert.assertEquals((long)numOfExpectedGroups, (long)detailLineGroupMap.size());
        EffortCertificationDetail expectedSummaryLine = this.buildDetailLine(testTarget, "expectedSummaryLine");
        EffortCertificationDetail expectedDelegateLine = this.buildDetailLine(testTarget, "expectedDelegateLine");
        EffortCertificationDetail summaryLine = null;
        EffortCertificationDetail delegateLine = null;
        for (String key : detailLineGroupMap.keySet()) {
            summaryLine = ((DetailLineGroup)detailLineGroupMap.get(key)).getSummaryDetailLine();
            delegateLine = ((DetailLineGroup)detailLineGroupMap.get(key)).getDelegateDetailLine();
        }
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        Assert.assertTrue((boolean)ObjectUtil.equals((Object)expectedSummaryLine, (Object)summaryLine, (List)keyFields));
        Assert.assertTrue((boolean)ObjectUtil.equals((Object)expectedDelegateLine, delegateLine, (List)keyFields));
    }

    @Test
    public void groupDetailLines_MultipleGroups() {
        String testTarget = "groupDetailLines.multipleGroups.";
        int numberOfDetails = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfDetails")));
        List<EffortCertificationDetail> detailLines = this.buildDetailLines(testTarget, "detail", numberOfDetails);
        Map detailLineGroupMap = DetailLineGroup.groupDetailLines(detailLines);
        int numOfExpectedGroups = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedGroups")));
        Assert.assertEquals((long)numOfExpectedGroups, (long)detailLineGroupMap.size());
        List<EffortCertificationDetail> expectedSummaryLines = this.buildDetailLines(testTarget, "expectedSummaryLine", numOfExpectedGroups);
        List<EffortCertificationDetail> expectedDelegateLines = this.buildDetailLines(testTarget, "expectedDelegateLine", numOfExpectedGroups);
        ArrayList<EffortCertificationDetail> summaryLines = new ArrayList<EffortCertificationDetail>();
        ArrayList<EffortCertificationDetail> delegateLines = new ArrayList<EffortCertificationDetail>();
        for (String key : detailLineGroupMap.keySet()) {
            summaryLines.add(((DetailLineGroup)detailLineGroupMap.get(key)).getSummaryDetailLine());
            delegateLines.add(((DetailLineGroup)detailLineGroupMap.get(key)).getDelegateDetailLine());
        }
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        Assert.assertTrue((boolean)TestDataPreparator.hasSameElements(expectedSummaryLines, summaryLines, (List)keyFields));
        Assert.assertTrue((boolean)TestDataPreparator.hasSameElements(expectedDelegateLines, delegateLines, (List)keyFields));
    }

    private List<EffortCertificationDetail> buildDetailLines(String testTarget, String propertyKeyPrefix, int numberOfDetails) {
        return TestDataPreparator.buildTestDataList(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + propertyKeyPrefix), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetails);
    }

    private EffortCertificationDetail buildDetailLine(String testTarget, String propertyKeyPrefix) {
        return (EffortCertificationDetail)TestDataPreparator.buildTestDataObject(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + propertyKeyPrefix), (String)this.detailFieldNames, (String)this.deliminator);
    }
}

