/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.batch.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.impl.parameter.ParameterBo;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.integration.ld.LaborLedgerEntry;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ec.batch.EffortCertificationExtractStep;
import org.kuali.kfs.module.ec.batch.service.EffortCertificationExtractService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;

@ConfigureContext
public class EffortCertificationExtractServiceTest
extends KualiTestBase {
    private final Properties properties;
    private final Properties message;
    private final String balanceFieldNames;
    private final String entryFieldNames;
    private final String detailFieldNames;
    private final String documentFieldNames;
    private final String documentHeaderFieldNames;
    private final String reportDefinitionFieldNames;
    private final String deliminator;
    private BusinessObjectService businessObjectService;
    private EffortCertificationExtractService effortCertificationExtractService;
    private Class<? extends LaborLedgerBalance> ledgerBalanceClass;
    private Class<? extends LaborLedgerEntry> ledgerEntryClass;

    public EffortCertificationExtractServiceTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationExtractService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.balanceFieldNames = this.properties.getProperty("balanceFieldNames");
        this.entryFieldNames = this.properties.getProperty("entryFieldNames");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.documentFieldNames = this.properties.getProperty("documentFieldNames");
        this.reportDefinitionFieldNames = this.properties.getProperty("reportDefinitionFieldNames");
        this.documentHeaderFieldNames = this.properties.getProperty("documentHeaderFieldNames");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.effortCertificationExtractService = (EffortCertificationExtractService)SpringContext.getBean(EffortCertificationExtractService.class);
        KualiModuleService kualiModuleService = (KualiModuleService)SpringContext.getBean(KualiModuleService.class);
        this.ledgerBalanceClass = LedgerBalance.class;
        this.ledgerEntryClass = ((LaborLedgerEntry)kualiModuleService.getResponsibleModuleService(LaborLedgerEntry.class).createNewObjectFromExternalizableClass(LaborLedgerEntry.class)).getClass();
    }

    public void testInputParameters_ValidParameters() throws Exception {
        String testTarget = "inputParameters.validParameters.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition();
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerEntryClass, (Properties)this.properties, (String)(testTarget + "dataCleanup"), (String)this.entryFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        try {
            this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            EffortCertificationExtractServiceTest.fail((String)this.message.getProperty("error.validParameters"));
        }
    }

    public void testInputParameters_EmptyFiscalYear() {
        String testTarget = "inputParameters.emptyFiscalYear.";
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        try {
            this.effortCertificationExtractService.extract(null, reportNumber);
            EffortCertificationExtractServiceTest.fail((String)this.message.getProperty("error.emptyFiscalYear"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationExtractServiceTest.assertEquals((String)"Fiscal Year is Required.", (String)iae.getMessage());
        }
    }

    public void testInputParameters_EmptyReportNumber() {
        String testTarget = "inputParameters.emptyReportNumber.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        try {
            this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
            EffortCertificationExtractServiceTest.fail((String)this.message.getProperty("error.emptyReportNumber"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationExtractServiceTest.assertEquals((String)"Report Number is Required.", (String)iae.getMessage());
        }
    }

    public void testInputParameters_UndefinedReportDefinition() {
        String testTarget = "inputParameters.undefinedReportDefinition.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        try {
            this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
            EffortCertificationExtractServiceTest.fail((String)this.message.getProperty("error.undefinedReportDefinition"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationExtractServiceTest.assertEquals((String)("The report definition associated with the specified report number and fiscal year was not found .[" + fiscalYear + ", " + reportNumber + "]"), (String)iae.getMessage());
        }
    }

    public void testInputParameters_InactiveReportDefinition() {
        String testTarget = "inputParameters.inactiveReportDefinition.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition();
        reportDefinition = (EffortCertificationReportDefinition)TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        reportDefinition.setActive(false);
        try {
            this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
            EffortCertificationExtractServiceTest.fail((String)this.message.getProperty("error.inactiveReportDefinition"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationExtractServiceTest.assertEquals((String)("The report definition associated with the specified report number and fiscal year is inactive.[" + fiscalYear + ", " + reportNumber + "]"), (String)iae.getMessage());
        }
    }

    public void testInputParameters_DocumentExist() {
        String testTarget = "inputParameters.documentExist.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition();
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        FinancialSystemDocumentHeader documentHeader = (FinancialSystemDocumentHeader)TestDataPreparator.buildTestDataObject(FinancialSystemDocumentHeader.class, (Properties)this.properties, (String)(testTarget + "documentHeader"), (String)this.documentHeaderFieldNames, (String)this.deliminator);
        documentHeader = (FinancialSystemDocumentHeader)TestDataPreparator.persistDataObject((PersistableBusinessObject)documentHeader);
        EffortCertificationDocument document = this.buildDocument(testTarget);
        document.setDocumentHeader((DocumentHeader)documentHeader);
        TestDataPreparator.persistDataObject((PersistableBusinessObject)document);
        try {
            this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
            EffortCertificationExtractServiceTest.fail((String)this.message.getProperty("error.documentExist"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationExtractServiceTest.assertEquals((String)("Data for report number " + reportNumber + ", fiscal year " + fiscalYear + " already exists in detail table."), (String)iae.getMessage());
        }
    }

    public void testEmployeeSelection_Selected() throws Exception {
        String testTarget = "employeeSelection.selected.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters("");
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
    }

    public void testEmployeeSelection_NotSelected() throws Exception {
        String testTarget = "employeeSelection.notSelected.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters("");
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
    }

    public void testBalanceSelection_Selected() throws Exception {
        String testTarget = "balanceSelection.selected.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters("");
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        List expectedDocumentBuildList = TestDataPreparator.buildExpectedValueList(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDocument"), (String)this.documentFieldNames, (String)this.deliminator, (int)numberOfExpectedDocuments);
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
        List documentKeyFields = ObjectUtil.split((String)this.documentFieldNames, (String)this.deliminator);
        documentKeyFields.remove("documentNumber");
        EffortCertificationExtractServiceTest.assertTrue((boolean)TestDataPreparator.hasSameElements((List)documentBuildList, (List)expectedDocumentBuildList, (List)documentKeyFields));
        ArrayList detailLinesBuild = new ArrayList();
        for (EffortCertificationDocumentBuild document : documentBuildList) {
            detailLinesBuild.addAll(document.getEffortCertificationDetailLinesBuild());
        }
        int numberOfExpectedDetailLines = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDetails"));
        List expectedDetailLines = TestDataPreparator.buildExpectedValueList(EffortCertificationDetailBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDetail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfExpectedDetailLines);
        EffortCertificationExtractServiceTest.assertEquals((int)expectedDetailLines.size(), (int)detailLinesBuild.size());
        List detailLineKeyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        detailLineKeyFields.remove("universityFiscalYear");
        EffortCertificationExtractServiceTest.assertTrue((boolean)TestDataPreparator.hasSameElements(detailLinesBuild, (List)expectedDetailLines, (List)detailLineKeyFields));
    }

    public void testBalanceSelection_UnqualifiedBalanceType() throws Exception {
        String testTarget = "balanceSelection.unqualifiedBalanceType.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters("");
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
    }

    public void testBalanceSelection_UnqualifiedObjectType() throws Exception {
        String testTarget = "balanceSelection.unqualifiedObjectType.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters("");
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
    }

    public void testBalanceSelection_NotSalary() throws Exception {
        String testTarget = "balanceSelection.notSalary.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters("");
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
    }

    public void testBalanceSelection_NotGrantAccount() throws Exception {
        String testTarget = "balanceSelection.notGrantAccount.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters("");
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
    }

    public void testBalanceSelection_ZeroAmountBalance() throws Exception {
        String testTarget = "balanceSelection.zeroAmountBalance.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters("");
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
    }

    public void testBalanceSelection_NonpositiveTotalAmount() throws Exception {
        String testTarget = "balanceSelection.nonpositiveTotalAmount.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters("");
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
    }

    public void testDocumentGeneration() throws Exception {
        String testTarget = "documentGeneration.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters(testTarget);
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        List expectedDocumentBuildList = TestDataPreparator.buildExpectedValueList(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDocument"), (String)this.documentFieldNames, (String)this.deliminator, (int)numberOfExpectedDocuments);
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
        List documentKeyFields = ObjectUtil.split((String)this.documentFieldNames, (String)this.deliminator);
        documentKeyFields.remove("documentNumber");
        EffortCertificationExtractServiceTest.assertTrue((boolean)TestDataPreparator.hasSameElements((List)documentBuildList, (List)expectedDocumentBuildList, (List)documentKeyFields));
        ArrayList detailLinesBuild = new ArrayList();
        for (EffortCertificationDocumentBuild document : documentBuildList) {
            detailLinesBuild.addAll(document.getEffortCertificationDetailLinesBuild());
        }
        int numberOfExpectedDetailLines = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDetails"));
        List expectedDetailLines = TestDataPreparator.buildExpectedValueList(EffortCertificationDetailBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDetail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfExpectedDetailLines);
        List detailLineKeyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        detailLineKeyFields.remove("universityFiscalYear");
        EffortCertificationExtractServiceTest.assertTrue((boolean)TestDataPreparator.hasSameElements(detailLinesBuild, (List)expectedDetailLines, (List)detailLineKeyFields));
    }

    public void testFederalGrantOnly_HasFederalGrant() throws Exception {
        String testTarget = "federalGrantOnly.hasFederalGrant.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters(testTarget);
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        List expectedDocumentBuildList = TestDataPreparator.buildExpectedValueList(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDocument"), (String)this.documentFieldNames, (String)this.deliminator, (int)numberOfExpectedDocuments);
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
        List documentKeyFields = ObjectUtil.split((String)this.documentFieldNames, (String)this.deliminator);
        documentKeyFields.remove("documentNumber");
        EffortCertificationExtractServiceTest.assertTrue((boolean)TestDataPreparator.hasSameElements((List)documentBuildList, (List)expectedDocumentBuildList, (List)documentKeyFields));
        ArrayList detailLinesBuild = new ArrayList();
        for (EffortCertificationDocumentBuild document : documentBuildList) {
            detailLinesBuild.addAll(document.getEffortCertificationDetailLinesBuild());
        }
        int numberOfExpectedDetailLines = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDetails"));
        List expectedDetailLines = TestDataPreparator.buildExpectedValueList(EffortCertificationDetailBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDetail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfExpectedDetailLines);
        EffortCertificationExtractServiceTest.assertEquals((int)expectedDetailLines.size(), (int)detailLinesBuild.size());
        List detailLineKeyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        detailLineKeyFields.remove("universityFiscalYear");
        EffortCertificationExtractServiceTest.assertTrue((boolean)TestDataPreparator.hasSameElements(detailLinesBuild, (List)expectedDetailLines, (List)detailLineKeyFields));
    }

    public void testFederalGrantOnly_NoFederalGrant() throws Exception {
        String testTarget = "federalGrantOnly.noFederalGrant.";
        Integer fiscalYear = Integer.valueOf(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        this.loadTestData(testTarget);
        this.updateSystemParameters(testTarget);
        this.effortCertificationExtractService.extract(fiscalYear, reportNumber);
        List documentBuildList = TestDataPreparator.findMatching(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        EffortCertificationExtractServiceTest.assertEquals((int)numberOfExpectedDocuments, (int)documentBuildList.size());
    }

    private void loadTestData(String testTarget) throws Exception {
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerEntryClass, (Properties)this.properties, (String)(testTarget + "dataCleanup"), (String)this.entryFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "dataCleanup"), (String)this.balanceFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "documentCleanup"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfEntries = Integer.parseInt(this.properties.getProperty(testTarget + "numOfEntries"));
        List ledgerEntries = TestDataPreparator.buildTestDataList(this.ledgerEntryClass, (Properties)this.properties, (String)(testTarget + "inputEntry"), (String)this.entryFieldNames, (String)this.deliminator, (int)numberOfEntries);
        TestDataPreparator.persistDataObject((List)ledgerEntries);
        int numberOfBalances = Integer.parseInt(this.properties.getProperty(testTarget + "numOfBalances"));
        List ledgerBalances = TestDataPreparator.buildTestDataList(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator, (int)numberOfBalances);
        TestDataPreparator.persistDataObject((List)ledgerBalances);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition();
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
    }

    private EffortCertificationReportDefinition buildReportDefinition() {
        return (EffortCertificationReportDefinition)TestDataPreparator.buildTestDataObject(EffortCertificationReportDefinition.class, (Properties)this.properties, (String)"reportDefinitionFieldValues", (String)this.reportDefinitionFieldNames, (String)this.deliminator);
    }

    private EffortCertificationDocument buildDocument(String testTarget) {
        return (EffortCertificationDocument)TestDataPreparator.buildTestDataObject(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "document"), (String)this.documentFieldNames, (String)this.deliminator);
    }

    private void updateSystemParameters(String testTarget) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("namespaceCode", "KFS-EC");
        fieldValues.put("componentCode", EffortCertificationExtractStep.class.getSimpleName());
        fieldValues.put("applicationId", "KFS");
        List parameters = (List)this.businessObjectService.findMatching(ParameterBo.class, fieldValues);
        for (ParameterBo param : parameters) {
            String name = param.getName();
            String propertyKey = testTarget + "systemParameter." + name;
            String propertyValue = StringUtils.trim((String)this.properties.getProperty(propertyKey));
            if (propertyValue == null) continue;
            TestUtils.setSystemParameter(EffortCertificationExtractStep.class, (String)name, (String)propertyValue);
        }
    }
}

