/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.validation.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.validation.impl.LedgerBalanceFieldValidator;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.LedgerBalanceForEffortCertification;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LedgerBalanceFieldValidatorTest
extends KualiTestBase {
    private Properties properties;
    private Properties message;
    private String balanceFieldNames;
    private String deliminator;
    private BusinessObjectService businessObjectService;
    private PersistenceService persistenceService;
    private Class<? extends LaborLedgerBalance> ledgerBalanceClass;

    public LedgerBalanceFieldValidatorTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/ledgerBalanceFieldValidator.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.balanceFieldNames = this.properties.getProperty("balanceFieldNames");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.persistenceService = (PersistenceService)SpringContext.getBean(PersistenceService.class);
        this.ledgerBalanceClass = LedgerBalanceForEffortCertification.class;
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerBalanceClass, (Properties)this.properties, (String)"dataCleanup", (String)this.balanceFieldNames, (String)this.deliminator);
    }

    public void testHasValidAccount_valid() {
        String testTarget = "hasValidAccount.valid.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.hasValidAccount((LaborLedgerBalance)ledgerBalance);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasValidAccount.valid");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsInFundGroups_Contain() {
        String testTarget = "isInFundGroups.contain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "fundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInFundGroups.contain");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsInFundGroups_NotContain() {
        String testTarget = "isInFundGroups.notContain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "fundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInFundGroups.notContain");
        LedgerBalanceFieldValidatorTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsInSubFundGroups_Contain() {
        String testTarget = "isInSubFundGroups.contain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "subFundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInSubFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInSubFundGroups.contain");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsInSubFundGroups_NotContain() {
        String testTarget = "isInSubFundGroups.notContain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "subFundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInSubFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInSubFundGroups.notContain");
        LedgerBalanceFieldValidatorTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsNonZeroAmountBalanceWithinReportPeriod_IsNonZeroAmount() {
        String testTarget = "isNonZeroAmountBalanceWithinReportPeriod.isNonZeroAmount.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod((LaborLedgerBalance)ledgerBalance, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod.isNonZeroAmount");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsNonZeroAmountBalanceWithinReportPeriod_IsZeroAmount() {
        String testTarget = "isNonZeroAmountBalanceWithinReportPeriod.isZeroAmount.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod((LaborLedgerBalance)ledgerBalance, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod.isZeroAmount");
        LedgerBalanceFieldValidatorTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsTotalAmountPositive_IsPositive() {
        String testTarget = "isTotalAmountPositive.isPositive.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isTotalAmountPositive.isPositive");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsTotalAmountPositive_IsZero() {
        String testTarget = "isTotalAmountPositive.isZero.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isTotalAmountPositive.isZero");
        LedgerBalanceFieldValidatorTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsTotalAmountPositive_IsNegative() {
        String testTarget = "isTotalAmountPositive.isNegative.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isTotalAmountPositive.isNegative");
        LedgerBalanceFieldValidatorTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasGrantAccount_ByFundGroup_Contain() {
        String testTarget = "hasGrantAccount.byFundGroup.contain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.byFundGroup.contain");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasGrantAccount_ByFundGroup_NotContain() {
        String testTarget = "hasGrantAccount.byFundGroup.notContain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.byFundGroup.notContain");
        LedgerBalanceFieldValidatorTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasGrantAccount_BySubFundGroup_Contain() {
        String testTarget = "hasGrantAccount.bySubFundGroup.contain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.bySubFundGroup.contain");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasGrantAccount_BySubFundGroup_NotContain() {
        String testTarget = "hasGrantAccount.bySubFundGroup.notContain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.bySubFundGroup.notContain");
        LedgerBalanceFieldValidatorTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsFromSingleOrganization_Single() {
        String testTarget = "isFromSingleOrganization.single.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isFromSingleOrganization(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isFromSingleOrganization.single");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsFromSingleOrganization_Multiple() {
        String testTarget = "isFromSingleOrganization.multiple.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isFromSingleOrganization(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isFromSingleOrganization.multiple");
        LedgerBalanceFieldValidatorTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasFederalFunds_FederalFunds() {
        String testTarget = "hasFederalFunds.federalFunds.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List federalAgencyTypeCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "federalAgencyTypeCodes"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, (Collection)federalAgencyTypeCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasFederalFunds.federalFunds");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasFederalFunds_PassThrough() {
        String testTarget = "hasFederalFunds.passThrough.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List federalAgencyTypeCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "federalAgencyTypeCodes"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, (Collection)federalAgencyTypeCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasFederalFunds.passThrough");
        LedgerBalanceFieldValidatorTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasFederalFunds_NoFederalFunds() {
        String testTarget = "hasFederalFunds.noFederalFunds.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List federalAgencyTypeCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "federalAgencyTypeCodes"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, (Collection)federalAgencyTypeCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasFederalFunds.noFederalFunds");
        LedgerBalanceFieldValidatorTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    private LaborLedgerBalance buildLedgerBalance(String testTarget) {
        LaborLedgerBalance ledgerBalance = (LaborLedgerBalance)TestDataPreparator.buildTestDataObject(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator);
        this.businessObjectService.save((PersistableBusinessObject)ledgerBalance);
        this.persistenceService.retrieveNonKeyFields((Object)ledgerBalance);
        ledgerBalance.refreshNonUpdateableReferences();
        return ledgerBalance;
    }

    private List<LaborLedgerBalance> buildLedgerBalances(String testTarget) {
        int numberOfTestData = Integer.parseInt(this.properties.getProperty(testTarget + "numOfData"));
        List ledgerBalances = TestDataPreparator.buildTestDataList(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator, (int)numberOfTestData);
        this.businessObjectService.save(ledgerBalances);
        for (LaborLedgerBalance balance : ledgerBalances) {
            this.persistenceService.retrieveNonKeyFields((Object)balance);
            balance.refreshNonUpdateableReferences();
        }
        return ledgerBalances;
    }

    private EffortCertificationReportDefinition buildReportDefinition(String testTarget) {
        EffortCertificationReportDefinition reportDefinition = new EffortCertificationReportDefinition();
        String reportDefinitionFieldNames = this.properties.getProperty("reportDefinitionFieldNames");
        ObjectUtil.populateBusinessObject((Object)reportDefinition, (Properties)this.properties, (String)(testTarget + "reportDefinitionFieldValues"), (String)reportDefinitionFieldNames, (String)this.deliminator);
        return reportDefinition;
    }
}

