/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service;

import java.util.List;
import java.util.Properties;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.service.EffortCertificationDetailBuildService;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class EffortCertificationDetailBuildServiceTest
extends KualiTestBase {
    private Properties properties;
    private Properties message;
    private String balanceFieldNames;
    private String detailFieldNames;
    private String deliminator;
    Integer postingYear;
    private EffortCertificationReportDefinition reportDefinition;
    private BusinessObjectService businessObjectService;
    private PersistenceService persistenceService;
    private EffortCertificationDetailBuildService effortCertificationDetailBuildService;
    private Class<? extends LaborLedgerBalance> ledgerBalanceClass;

    public EffortCertificationDetailBuildServiceTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationDetailBuildService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.balanceFieldNames = this.properties.getProperty("balanceFieldNames");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.postingYear = Integer.valueOf(this.properties.getProperty("postingYear"));
    }

    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.persistenceService = (PersistenceService)SpringContext.getBean(PersistenceService.class);
        this.effortCertificationDetailBuildService = (EffortCertificationDetailBuildService)SpringContext.getBean(EffortCertificationDetailBuildService.class);
        this.ledgerBalanceClass = LedgerBalance.class;
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerBalanceClass, (Properties)this.properties, (String)"dataCleanup", (String)this.balanceFieldNames, (String)this.deliminator);
    }

    public void testGenerateDetailBuild_NullSubAccount() {
        String testTarget = "generateDetailBuild.nullSubAccount.";
        this.reportDefinition = this.buildReportDefinition("");
        this.assertDetailEquals(testTarget);
    }

    public void testGenerateDetailBuild_ExpenseSubAccount() {
        String testTarget = "generateDetailBuild.expenseSubAccount.";
        this.reportDefinition = this.buildReportDefinition("");
        this.assertDetailEquals(testTarget);
    }

    public void testGenerateDetailBuild_CostShareSubAccount() {
        String testTarget = "generateDetailBuild.costShareSubAccount.";
        this.reportDefinition = this.buildReportDefinition("");
        this.assertDetailEquals(testTarget);
    }

    public void testGenerateDetailBuild_LongReportPeriod() {
        String testTarget = "generateDetailBuild.longReportPeriod.";
        this.reportDefinition = this.buildReportDefinition(testTarget);
        this.assertDetailEquals(testTarget);
    }

    private void assertDetailEquals(String testTarget) {
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        EffortCertificationDetailBuild detailBuild = this.effortCertificationDetailBuildService.generateDetailBuild(this.postingYear, ledgerBalance, this.reportDefinition);
        System.out.printf("FringeBenefitAmount = %s; PayrollAmount = %s.\n", detailBuild.getFringeBenefitAmount(), detailBuild.getEffortCertificationPayrollAmount());
        EffortCertificationDetailBuild expectedDetailBuild = (EffortCertificationDetailBuild)TestDataPreparator.buildTestDataObject(EffortCertificationDetailBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDetail"), (String)this.detailFieldNames, (String)this.deliminator);
        String errorMessage = this.message.getProperty("error.detailBuildService.unexpectedDetailLineGenerated");
        EffortCertificationDetailBuildServiceTest.assertTrue((String)errorMessage, (boolean)ObjectUtil.equals((Object)detailBuild, (Object)expectedDetailBuild, (List)keyFields));
    }

    private LaborLedgerBalance buildLedgerBalance(String testTarget) {
        LaborLedgerBalance ledgerBalance = (LaborLedgerBalance)TestDataPreparator.buildTestDataObject(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator);
        this.businessObjectService.save((PersistableBusinessObject)ledgerBalance);
        this.persistenceService.retrieveNonKeyFields((Object)ledgerBalance);
        return ledgerBalance;
    }

    private EffortCertificationReportDefinition buildReportDefinition(String testTarget) {
        EffortCertificationReportDefinition reportDefinition = new EffortCertificationReportDefinition();
        String reprtDefinitionFieldNames = this.properties.getProperty("reportDefinitionFieldNames");
        ObjectUtil.populateBusinessObject((Object)reportDefinition, (Properties)this.properties, (String)(testTarget + "reportDefinitionFieldValues"), (String)reprtDefinitionFieldNames, (String)this.deliminator);
        return reportDefinition;
    }
}

