/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.validation.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.EffortConstants;
import org.kuali.kfs.module.ec.batch.service.EffortCertificationExtractService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.document.validation.AddDetailLineRule;
import org.kuali.kfs.module.ec.document.validation.CheckDetailLineAmountRule;
import org.kuali.kfs.module.ec.document.validation.LoadDetailLineRule;
import org.kuali.kfs.module.ec.document.validation.UpdateDetailLineRule;
import org.kuali.kfs.module.ec.document.validation.impl.EffortCertificationDocumentRuleUtil;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentService;
import org.kuali.kfs.module.ec.service.EffortCertificationReportDefinitionService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.AccountingLineRuleHelperService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class EffortCertificationDocumentRules
extends TransactionalDocumentRuleBase
implements AddDetailLineRule<EffortCertificationDocument, EffortCertificationDetail>,
UpdateDetailLineRule<EffortCertificationDocument, EffortCertificationDetail>,
CheckDetailLineAmountRule<EffortCertificationDocument, EffortCertificationDetail>,
LoadDetailLineRule<EffortCertificationDocument> {
    private static final Logger LOG = LogManager.getLogger(EffortCertificationDocumentRules.class);
    protected EffortCertificationDocumentService effortCertificationDocumentService = (EffortCertificationDocumentService)SpringContext.getBean(EffortCertificationDocumentService.class);
    protected EffortCertificationReportDefinitionService effortCertificationReportDefinitionService = (EffortCertificationReportDefinitionService)SpringContext.getBean(EffortCertificationReportDefinitionService.class);
    protected EffortCertificationExtractService effortCertificationExtractService = (EffortCertificationExtractService)SpringContext.getBean(EffortCertificationExtractService.class);
    protected BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    protected LaborModuleService laborModuleService = (LaborModuleService)SpringContext.getBean(LaborModuleService.class);
    protected AccountingLineRuleHelperService accountingLineRuleHelperService = (AccountingLineRuleHelperService)SpringContext.getBean(AccountingLineRuleHelperService.class);

    @Override
    public boolean processAddDetailLineRules(EffortCertificationDocument document, EffortCertificationDetail detailLine) {
        LOG.debug("processAddDetailLineRules() start");
        document.refreshNonUpdateableReferences();
        detailLine.refreshNonUpdateableReferences();
        if (!this.checkDetailLineAttributes(detailLine)) {
            return false;
        }
        if (!this.processCheckDetailLineAmountRules(document, detailLine)) {
            return false;
        }
        List<String> comparableFields = EffortConstants.DETAIL_LINES_CONSOLIDATION_FIELDS;
        if (detailLine.isNewLineIndicator() && EffortCertificationDocumentRuleUtil.hasSameExistingLine(document, detailLine, comparableFields)) {
            this.reportError("newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "error.effort.lineExists", new String[0]);
            return false;
        }
        if (EffortCertificationDocumentRuleUtil.hasClosedAccount(detailLine)) {
            this.reportError("newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "error.effort.accountClosed", new String[0]);
            return false;
        }
        if (detailLine.isNewLineIndicator() && !EffortCertificationDocumentRuleUtil.canExpiredAccountBeUsed(detailLine)) {
            Account account = detailLine.getAccount();
            Account continuation = account.getContinuationAccount();
            this.reportError("newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "error.document.accountExpired", account.getAccountNumber(), continuation.getChartOfAccountsCode(), continuation.getAccountNumber());
            return false;
        }
        return true;
    }

    @Override
    public boolean processUpdateDetailLineRules(EffortCertificationDocument document, EffortCertificationDetail detailLine) {
        LOG.debug("processUpdateDetailLineRules() start");
        if (detailLine.isNewLineIndicator() && !this.processAddDetailLineRules(document, detailLine)) {
            return false;
        }
        if (!this.processCheckDetailLineAmountRules(document, detailLine)) {
            return false;
        }
        KualiDecimal originalTotalAmount = document.getTotalOriginalPayrollAmount();
        if (EffortCertificationDocumentRuleUtil.isPayrollAmountOverChanged(detailLine, originalTotalAmount, 0.005)) {
            this.reportError("newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "error.effort.payrollAmountOverChanged", Double.valueOf(0.005).toString());
            return false;
        }
        return true;
    }

    public boolean processCustomApproveDocumentBusinessRules(ApproveDocumentEvent approveEvent) {
        LOG.debug("processAddLineBusinessRules() start");
        EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument)approveEvent.getDocument();
        if (this.bypassBusinessRuleIfInitiation(effortCertificationDocument)) {
            return true;
        }
        boolean valid = true;
        for (EffortCertificationDetail detailLine : effortCertificationDocument.getEffortCertificationDetailLines()) {
            valid &= this.processUpdateDetailLineRules(effortCertificationDocument, detailLine);
        }
        return valid &= this.processCustomRouteDocumentBusinessRules((Document)effortCertificationDocument);
    }

    public boolean processCustomRouteDocumentBusinessRules(Document document) {
        List notes;
        LOG.debug("processAddLineBusinessRules() start");
        EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument)document;
        if (!EffortCertificationDocumentRuleUtil.hasDetailLine(effortCertificationDocument)) {
            this.reportError("newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "error.effort.notHaveDetailLine", new String[0]);
            return false;
        }
        if (this.bypassBusinessRuleIfInitiation(effortCertificationDocument)) {
            return true;
        }
        if (EffortCertificationDocumentRuleUtil.isEffortPercentChangedFromPersisted(effortCertificationDocument)) {
            List notes2 = effortCertificationDocument.getNotes();
            boolean noteHasBeenAdded = false;
            for (Note note : notes2) {
                if (!note.isNewCollectionRecord()) continue;
                noteHasBeenAdded = true;
                break;
            }
            if (!noteHasBeenAdded) {
                this.reportError("newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "error.effort.noteRequiredWhenEffortChanged", new String[0]);
                return false;
            }
        }
        if (EffortCertificationDocumentRuleUtil.isTotalPayrollAmountOverChanged(effortCertificationDocument, 0.009)) {
            this.reportError("newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "error.effort.totalPayrollAmountOverChanged", Double.valueOf(0.009).toString());
            return false;
        }
        if (!EffortCertificationDocumentRuleUtil.isTotalEffortPercentageAs100(effortCertificationDocument)) {
            this.reportError("newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "error.effort.totalEffortPercentageNot100", new String[0]);
            return false;
        }
        String emplid = effortCertificationDocument.getEmplid();
        effortCertificationDocument.refreshReferenceObject("effortCertificationReportDefinition");
        EffortCertificationReportDefinition reportDefinition = effortCertificationDocument.getEffortCertificationReportDefinition();
        if (this.effortCertificationReportDefinitionService.hasApprovedEffortCertification(emplid, reportDefinition) && ((notes = effortCertificationDocument.getNotes()) == null || notes.isEmpty())) {
            this.reportError("newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "error.effort.noteRequiredWhenApprovedEffortCertificationExist", emplid, reportDefinition.getUniversityFiscalYear().toString(), reportDefinition.getEffortCertificationReportNumber());
            return false;
        }
        return true;
    }

    @Override
    public boolean processCheckDetailLineAmountRules(EffortCertificationDocument effortCertificationDocument, EffortCertificationDetail effortCertificationDetail) {
        if (!EffortCertificationDocumentRuleUtil.hasValidEffortPercent(effortCertificationDetail)) {
            this.reportError("effortCertificationUpdatedOverallPercent", "error.effort.invalidEffortPercent", new String[0]);
            return false;
        }
        if (!EffortCertificationDocumentRuleUtil.hasNonNegativePayrollAmount(effortCertificationDetail)) {
            this.reportError("effortCertificationPayrollAmount", "error.effort.negativePayrollAmount", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean processLoadDetailLineRules(EffortCertificationDocument effortCertificationDocument) {
        LOG.debug("processLoadDetailLineRules() start");
        String emplid = effortCertificationDocument.getEmplid();
        effortCertificationDocument.refreshReferenceObject("effortCertificationReportDefinition");
        EffortCertificationReportDefinition reportDefinition = effortCertificationDocument.getEffortCertificationReportDefinition();
        if (ObjectUtils.isNull((Object)((Object)reportDefinition))) {
            this.reportError("effortDetailImportError", "error.effort.reportDefinitionNotExist", new String[0]);
            return false;
        }
        if (!reportDefinition.isActive()) {
            this.reportError("effortDetailImportError", "error.effort.reportDefinitionInactive", new String[0]);
            return false;
        }
        boolean isValid = StringUtils.equals((CharSequence)"O", (CharSequence)reportDefinition.getEffortCertificationReportPeriodStatusCode());
        if (!isValid) {
            this.reportError("effortDetailImportError", "error.effort.reportDefinitionPeriodNotOpened", new String[0]);
            return false;
        }
        boolean bl = isValid = !this.effortCertificationReportDefinitionService.hasPendingEffortCertification(emplid, reportDefinition);
        if (!isValid) {
            this.reportError("effortDetailImportError", "error.effort.pendingEffortCertificationExist", new String[0]);
            return false;
        }
        isValid = this.effortCertificationReportDefinitionService.hasBeenUsedForEffortCertificationGeneration(reportDefinition);
        if (!isValid) {
            this.reportError("effortDetailImportError", "error.effort.createProcessHasNotBeenCompleted", new String[0]);
            return false;
        }
        isValid = this.effortCertificationExtractService.isEmployeeEligibleForEffortCertification(emplid, reportDefinition);
        if (!isValid) {
            this.reportError("effortDetailImportError", "error.effort.employeeNotEligibleForEffortCertification", emplid);
            return false;
        }
        int countOfPendingSalaryExpenseTransfer = this.laborModuleService.countPendingSalaryExpenseTransfer(emplid);
        if (countOfPendingSalaryExpenseTransfer > 0) {
            this.reportError("effortDetailImportError", "error.effort.pendingSalaryExpenseTransferExist", emplid, Integer.toString(countOfPendingSalaryExpenseTransfer));
            return false;
        }
        return this.populateEffortCertificationDocument(effortCertificationDocument);
    }

    protected boolean checkDetailLineAttributes(EffortCertificationDetail detailLine) {
        LOG.debug("checkDetailLine() start");
        boolean hasValidFormat = EffortCertificationDocumentRuleUtil.hasValidFormat(detailLine);
        boolean hasValidReference = true;
        if (hasValidFormat) {
            hasValidReference = this.accountingLineRuleHelperService.isValidAccount(detailLine.getAccount(), "newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "");
            hasValidReference &= this.accountingLineRuleHelperService.isValidChart(detailLine.getChartOfAccounts(), "newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "");
            if (!KFSConstants.getDashSubAccountNumber().equals(detailLine.getSubAccountNumber()) && StringUtils.isNotBlank((CharSequence)detailLine.getSubAccountNumber())) {
                hasValidReference &= this.accountingLineRuleHelperService.isValidSubAccount(detailLine.getSubAccount(), "newDetailLine.*,document.effortCertificationDetailLines*,document.summarizedDetailLines*", "");
            }
        }
        return hasValidFormat && hasValidReference;
    }

    protected boolean bypassBusinessRuleIfInitiation(EffortCertificationDocument effortCertificationDocument) {
        return effortCertificationDocument.getDocumentHeader().getWorkflowDocument().isInitiated();
    }

    protected boolean populateEffortCertificationDocument(EffortCertificationDocument effortCertificationDocument) {
        EffortCertificationReportDefinition reportDefinition;
        String emplid = effortCertificationDocument.getEmplid();
        EffortCertificationDocumentBuild documentBuild = this.effortCertificationExtractService.extract(emplid, reportDefinition = effortCertificationDocument.getEffortCertificationReportDefinition());
        if (documentBuild == null) {
            this.reportError("effortDetailImportError", "error.effort.employeeNoEligibleLaborBalance", emplid);
            return false;
        }
        this.effortCertificationDocumentService.removeEffortCertificationDetailLines(effortCertificationDocument);
        boolean success = this.effortCertificationDocumentService.populateEffortCertificationDocument(effortCertificationDocument, documentBuild);
        if (this.effortCertificationReportDefinitionService.hasBeenUsedForEffortCertificationGeneration(emplid, reportDefinition)) {
            effortCertificationDocument.setEffortCertificationDocumentCode(true);
        }
        return success;
    }

    protected void reportError(String propertyName, String errorKey, String ... errorParameters) {
        GlobalVariables.getMessageMap().putError(propertyName, errorKey, errorParameters);
    }
}

