/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.validation.impl;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportPosition;

public class EffortCertificationReportDefinitionRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger(EffortCertificationReportDefinitionRule.class);

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        Collection<EffortCertificationReportPosition> reportPositions;
        LOG.debug("processCustomRouteDocumentBusinessRules() start");
        if (GlobalVariables.getMessageMap().getErrorCount() > 0) {
            return false;
        }
        boolean isValid = true;
        EffortCertificationReportDefinition reportDefinition = (EffortCertificationReportDefinition)document.getNewMaintainableObject().getBusinessObject();
        if (reportDefinition.getEffortCertificationReportBeginFiscalYear() > reportDefinition.getEffortCertificationReportEndFiscalYear() || reportDefinition.getEffortCertificationReportBeginFiscalYear().equals(reportDefinition.getEffortCertificationReportEndFiscalYear()) && Integer.parseInt(reportDefinition.getEffortCertificationReportBeginPeriodCode()) >= Integer.parseInt(reportDefinition.getEffortCertificationReportEndPeriodCode())) {
            this.putFieldError("effortCertificationReportEndFiscalYear", "error.effort.effortCertificationReport.endFiscalYear");
            isValid = false;
        }
        if ((reportPositions = reportDefinition.getEffortCertificationReportPositions()) == null || reportPositions.isEmpty()) {
            this.putFieldError("effortCertificationReportPositions", "error.effort.notHavePositionGroup");
            isValid = false;
        }
        if (ObjectUtils.isNull((Object)reportDefinition.getReportBeginPeriod())) {
            this.putFieldError("effortCertificationReportBeginFiscalYear", "error.rptdefn.begin.period.invalid");
            isValid = false;
        }
        if (ObjectUtils.isNull((Object)reportDefinition.getReportEndPeriod())) {
            this.putFieldError("effortCertificationReportEndFiscalYear", "error.rptdefn.end.period.invalid");
            isValid = false;
        }
        if (ObjectUtils.isNull((Object)reportDefinition.getExpenseTransferFiscalPeriod())) {
            this.putFieldError("expenseTransferFiscalYear", "error.rptdefn.transfer.period.invalid");
            isValid = false;
        }
        return isValid;
    }
}

