/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.module.ec.EffortConstants;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.sys.DynamicCollectionComparator;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class DetailLineGroup {
    EffortCertificationDetail summaryDetailLine;
    EffortCertificationDetail delegateDetailLine;
    List<EffortCertificationDetail> detailLines = new ArrayList<EffortCertificationDetail>();

    public DetailLineGroup() {
        this(null);
    }

    public DetailLineGroup(EffortCertificationDetail newDetailLine) {
        this.summaryDetailLine = new EffortCertificationDetail();
        if (newDetailLine != null) {
            String groupId = DetailLineGroup.getKeysAsString(newDetailLine);
            ObjectUtil.buildObject((Object)((Object)this.summaryDetailLine), (Object)((Object)newDetailLine));
            this.summaryDetailLine.setGroupId(groupId);
            this.addNewLineIntoGroup(newDetailLine, groupId);
        }
        this.summaryDetailLine.setFinancialObjectCode(null);
        this.summaryDetailLine.setPositionNumber(null);
    }

    public void updateDelegateDetailLineEffort() {
        Integer difference = this.getEffortPercentChanged();
        if (difference != 0) {
            Integer effortPercent = this.delegateDetailLine.getEffortCertificationUpdatedOverallPercent() + difference;
            this.delegateDetailLine.setEffortCertificationUpdatedOverallPercent(effortPercent);
        }
    }

    public void updateDetailLineEffortPercent() {
        int totalDifference = this.getEffortPercentChanged();
        List<EffortCertificationDetail> detailLines = this.getDetailLines();
        DynamicCollectionComparator.sort(detailLines, (DynamicCollectionComparator.SortOrder)DynamicCollectionComparator.SortOrder.DESC, (String[])new String[]{"persistedPayrollAmount"});
        for (EffortCertificationDetail detailLine : detailLines) {
            detailLine.setEffortCertificationUpdatedOverallPercent(detailLine.getPersistedEffortPercent());
        }
        for (EffortCertificationDetail detailLine : detailLines) {
            if (totalDifference == 0) break;
            int currentPercent = detailLine.getPersistedEffortPercent();
            int currentDifference = currentPercent + totalDifference;
            boolean needUpdateMultipleLines = currentDifference < 0;
            int effortPercent = needUpdateMultipleLines ? 0 : currentDifference;
            detailLine.setEffortCertificationUpdatedOverallPercent(effortPercent);
            totalDifference = needUpdateMultipleLines ? currentDifference : 0;
        }
    }

    public void updateDetailLinePayrollAmount() {
        KualiDecimal totalDifference = this.getPayrollAmountChanged();
        if (totalDifference.isZero()) {
            return;
        }
        List<EffortCertificationDetail> detailLines = this.getDetailLines();
        DynamicCollectionComparator.sort(detailLines, (DynamicCollectionComparator.SortOrder)DynamicCollectionComparator.SortOrder.DESC, (String[])new String[]{"persistedPayrollAmount"});
        for (EffortCertificationDetail detailLine : detailLines) {
            detailLine.setEffortCertificationPayrollAmount(detailLine.getPersistedPayrollAmount());
        }
        for (EffortCertificationDetail detailLine : detailLines) {
            if (totalDifference.isZero()) break;
            KualiDecimal currentAmount = detailLine.getPersistedPayrollAmount();
            KualiDecimal currentDifference = (KualiDecimal)currentAmount.add((AbstractKualiDecimal)totalDifference);
            boolean needUpdateMultipleLines = currentDifference.isNegative();
            KualiDecimal payrollAmount = needUpdateMultipleLines ? KualiDecimal.ZERO : currentDifference;
            detailLine.setEffortCertificationPayrollAmount(payrollAmount);
            totalDifference = needUpdateMultipleLines ? currentDifference : KualiDecimal.ZERO;
        }
    }

    public static Map<String, DetailLineGroup> groupDetailLines(List<EffortCertificationDetail> detailLines) {
        HashMap<String, DetailLineGroup> detailLineGroupMap = new HashMap<String, DetailLineGroup>();
        for (EffortCertificationDetail line : detailLines) {
            DetailLineGroup group;
            String groupId = DetailLineGroup.getKeysAsString(line);
            if (detailLineGroupMap.containsKey(groupId)) {
                group = (DetailLineGroup)detailLineGroupMap.get(groupId);
                group.addNewLineIntoGroup(line, groupId);
                continue;
            }
            group = new DetailLineGroup(line);
            detailLineGroupMap.put(groupId, group);
        }
        return detailLineGroupMap;
    }

    public static String getKeysAsString(EffortCertificationDetail line) {
        return ObjectUtil.concatPropertyAsString((Object)((Object)line), EffortConstants.DETAIL_LINES_GROUPING_FIELDS);
    }

    private Integer getEffortPercentChanged() {
        Integer currentEffortPercent = EffortCertificationDetail.getTotalPersistedEffortPercent(this.detailLines);
        Integer updatedEffortPercent = this.summaryDetailLine.getEffortCertificationUpdatedOverallPercent();
        return updatedEffortPercent - currentEffortPercent;
    }

    private KualiDecimal getPayrollAmountChanged() {
        KualiDecimal currentAmount = EffortCertificationDetail.getTotalPersistedPayrollAmount(this.detailLines);
        KualiDecimal updatedAmount = this.summaryDetailLine.getEffortCertificationPayrollAmount();
        return (KualiDecimal)updatedAmount.subtract((AbstractKualiDecimal)currentAmount);
    }

    private void addNewLineIntoGroup(EffortCertificationDetail newDetailLine, String groupId) {
        if (this.detailLines.contains((Object)newDetailLine)) {
            return;
        }
        newDetailLine.setGroupId(groupId);
        this.detailLines.add(newDetailLine);
        this.delegateDetailLine = this.getDetailLineWithMaxPayrollAmount(this.detailLines);
        this.updateSummaryDetailLineAmount();
    }

    private void updateSummaryDetailLineAmount() {
        Integer originalEffortPercent = EffortCertificationDetail.getTotalOriginalEffortPercent(this.detailLines);
        this.summaryDetailLine.setEffortCertificationCalculatedOverallPercent(originalEffortPercent);
        Integer effortPercent = EffortCertificationDetail.getTotalEffortPercent(this.detailLines);
        this.summaryDetailLine.setEffortCertificationUpdatedOverallPercent(effortPercent);
        Integer persistedEffortPercent = EffortCertificationDetail.getTotalPersistedEffortPercent(this.detailLines);
        this.summaryDetailLine.setPersistedEffortPercent(persistedEffortPercent);
        KualiDecimal originalPayrollAmount = EffortCertificationDetail.getTotalOriginalPayrollAmount(this.detailLines);
        this.summaryDetailLine.setEffortCertificationOriginalPayrollAmount(originalPayrollAmount);
        KualiDecimal payrollAmount = EffortCertificationDetail.getTotalPayrollAmount(this.detailLines);
        this.summaryDetailLine.setEffortCertificationPayrollAmount(payrollAmount);
        KualiDecimal persistedPayrollAmount = EffortCertificationDetail.getTotalPersistedPayrollAmount(this.detailLines);
        this.summaryDetailLine.setPersistedPayrollAmount(persistedPayrollAmount);
    }

    private EffortCertificationDetail getDetailLineWithMaxPayrollAmount(List<EffortCertificationDetail> detailLines) {
        KualiDecimal maxAmount = null;
        EffortCertificationDetail detailLineWithMaxPayrollAmount = null;
        for (EffortCertificationDetail line : detailLines) {
            KualiDecimal currentAmount = line.getEffortCertificationOriginalPayrollAmount();
            if (detailLineWithMaxPayrollAmount == null) {
                maxAmount = currentAmount;
                detailLineWithMaxPayrollAmount = line;
                continue;
            }
            if (!maxAmount.isLessThan((AbstractKualiDecimal)currentAmount)) continue;
            maxAmount = currentAmount;
            detailLineWithMaxPayrollAmount = line;
        }
        return detailLineWithMaxPayrollAmount;
    }

    public EffortCertificationDetail getSummaryDetailLine() {
        return this.summaryDetailLine;
    }

    public void setSummaryDetailLine(EffortCertificationDetail summaryDetailLine) {
        this.summaryDetailLine = summaryDetailLine;
    }

    public List<EffortCertificationDetail> getDetailLines() {
        return this.detailLines;
    }

    public void setDetailLines(List<EffortCertificationDetail> detailLines) {
        this.detailLines = detailLines;
    }

    public EffortCertificationDetail getDelegateDetailLine() {
        return this.delegateDetailLine;
    }

    public void setDelegateDetailLine(EffortCertificationDetail delegateDetailLine) {
        this.delegateDetailLine = delegateDetailLine;
    }
}

