/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.module.ec.util.AccountingPeriodMonth;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public final class LedgerBalanceConsolidationHelper {
    private LedgerBalanceConsolidationHelper() {
    }

    public static void consolidateLedgerBalances(Map<String, LaborLedgerBalance> ledgerBalanceMap, LaborLedgerBalance ledgerBalance, List<String> consolidationKeys) {
        String consolidationKeyFieldsAsString = ObjectUtil.concatPropertyAsString((Object)ledgerBalance, consolidationKeys);
        LedgerBalanceConsolidationHelper.consolidateLedgerBalances(ledgerBalanceMap, ledgerBalance, consolidationKeyFieldsAsString);
    }

    public static void consolidateLedgerBalances(Map<String, LaborLedgerBalance> ledgerBalanceMap, LaborLedgerBalance ledgerBalance, String consolidationKeyFieldsAsString) {
        if (ledgerBalanceMap.containsKey(consolidationKeyFieldsAsString)) {
            LaborLedgerBalance existingBalance = ledgerBalanceMap.get(consolidationKeyFieldsAsString);
            LedgerBalanceConsolidationHelper.addLedgerBalanceAmounts(existingBalance, ledgerBalance);
        } else {
            ledgerBalanceMap.put(consolidationKeyFieldsAsString, ledgerBalance);
        }
    }

    public static void consolidateLedgerBalances(Map<String, LaborLedgerBalance> ledgerBalanceMap, Collection<LaborLedgerBalance> ledgerBalances, List<String> consolidationKeys) {
        for (LaborLedgerBalance balance : ledgerBalances) {
            LedgerBalanceConsolidationHelper.consolidateLedgerBalances(ledgerBalanceMap, balance, consolidationKeys);
        }
    }

    public static void groupLedgerBalancesByKeys(Map<String, List<LaborLedgerBalance>> ledgerBalanceMap, LaborLedgerBalance ledgerBalance, List<String> consolidationKeys) {
        String consolidationKeyFieldsAsString = ObjectUtil.concatPropertyAsString((Object)ledgerBalance, consolidationKeys);
        LedgerBalanceConsolidationHelper.groupLedgerBalancesByKeys(ledgerBalanceMap, ledgerBalance, consolidationKeyFieldsAsString);
    }

    public static void groupLedgerBalancesByKeys(Map<String, List<LaborLedgerBalance>> ledgerBalanceMap, LaborLedgerBalance ledgerBalance, String consolidationKeyFieldsAsString) {
        if (ledgerBalanceMap.containsKey(consolidationKeyFieldsAsString)) {
            List<LaborLedgerBalance> balanceList = ledgerBalanceMap.get(consolidationKeyFieldsAsString);
            balanceList.add(ledgerBalance);
        } else {
            ArrayList<LaborLedgerBalance> balanceList = new ArrayList<LaborLedgerBalance>();
            balanceList.add(ledgerBalance);
            ledgerBalanceMap.put(consolidationKeyFieldsAsString, balanceList);
        }
    }

    public static void groupLedgerBalancesByKeys(Map<String, List<LaborLedgerBalance>> ledgerBalanceMap, Collection<LaborLedgerBalance> ledgerBalances, List<String> consolidationKeys) {
        for (LaborLedgerBalance balance : ledgerBalances) {
            LedgerBalanceConsolidationHelper.groupLedgerBalancesByKeys(ledgerBalanceMap, balance, consolidationKeys);
        }
    }

    public static void addLedgerBalanceAmounts(LaborLedgerBalance ledgerBalance, LaborLedgerBalance anotherLedgerBalance) {
        if (anotherLedgerBalance == null) {
            return;
        }
        if (ledgerBalance == null) {
            ledgerBalance = anotherLedgerBalance;
            return;
        }
        for (AccountingPeriodMonth period : AccountingPeriodMonth.values()) {
            KualiDecimal amount = anotherLedgerBalance.getAmountByPeriod(period.periodCode);
            ledgerBalance.addAmount(period.periodCode, amount);
        }
    }

    @Deprecated
    public static KualiDecimal calculateTotalAmountWithinReportPeriod(LaborLedgerBalance ledgerBalance, Map<Integer, Set<String>> reportPeriods, boolean allFiscalYears) {
        return LedgerBalanceConsolidationHelper.calculateTotalAmountWithinReportPeriod(ledgerBalance, reportPeriods);
    }

    public static KualiDecimal calculateTotalAmountWithinReportPeriod(LaborLedgerBalance ledgerBalance, Map<Integer, Set<String>> reportPeriods) {
        Integer fiscalYear = ledgerBalance.getUniversityFiscalYear();
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        Set<String> periodCodes = reportPeriods.get(fiscalYear);
        for (String period : periodCodes) {
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)ledgerBalance.getAmountByPeriod(period));
        }
        return totalAmount;
    }

    @Deprecated
    public static KualiDecimal calculateTotalAmountWithinReportPeriod(Collection<LaborLedgerBalance> ledgerBalances, Map<Integer, Set<String>> reportPeriods, boolean allFiscalYears) {
        return LedgerBalanceConsolidationHelper.calculateTotalAmountWithinReportPeriod(ledgerBalances, reportPeriods);
    }

    public static KualiDecimal calculateTotalAmountWithinReportPeriod(Collection<LaborLedgerBalance> ledgerBalances, Map<Integer, Set<String>> reportPeriods) {
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        for (LaborLedgerBalance ledgerBalance : ledgerBalances) {
            KualiDecimal totalAmountForOneBalance = LedgerBalanceConsolidationHelper.calculateTotalAmountWithinReportPeriod(ledgerBalance, reportPeriods);
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)totalAmountForOneBalance);
        }
        return totalAmount;
    }
}

