/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import org.kuali.kfs.sys.KFSConstants;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PayrollAmountHolder {
    private KualiDecimal payrollAmount;
    private Integer payrollPercent;
    private KualiDecimal totalAmount;
    private KualiDecimal accumulatedAmount;
    private Integer accumulatedPercent;

    public PayrollAmountHolder(KualiDecimal totalAmount, KualiDecimal accumulatedAmount, Integer accumulatedPercent) {
        this.totalAmount = totalAmount;
        this.accumulatedAmount = accumulatedAmount;
        this.accumulatedPercent = accumulatedPercent;
    }

    public KualiDecimal getPayrollAmount() {
        return this.payrollAmount;
    }

    public void setPayrollAmount(KualiDecimal payrollAmount) {
        this.payrollAmount = payrollAmount;
    }

    public Integer getPayrollPercent() {
        return this.payrollPercent;
    }

    public void setPayrollPercent(Integer payrollPercent) {
        this.payrollPercent = payrollPercent;
    }

    public KualiDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(KualiDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public KualiDecimal getAccumulatedAmount() {
        return this.accumulatedAmount;
    }

    public void setAccumulatedAmount(KualiDecimal accumulatedAmount) {
        this.accumulatedAmount = accumulatedAmount;
    }

    public Integer getAccumulatedPercent() {
        return this.accumulatedPercent;
    }

    public void setAccumulatedPercent(Integer accumulatedPercent) {
        this.accumulatedPercent = accumulatedPercent;
    }

    public static void calculatePayrollPercent(PayrollAmountHolder payrollAmountHolder) {
        KualiDecimal totalAmount = payrollAmountHolder.getTotalAmount();
        if (totalAmount.isZero()) {
            return;
        }
        KualiDecimal payrollAmount = payrollAmountHolder.getPayrollAmount();
        KualiDecimal accumulatedAmount = payrollAmountHolder.getAccumulatedAmount();
        accumulatedAmount = (KualiDecimal)accumulatedAmount.add((AbstractKualiDecimal)payrollAmount);
        int accumulatedPercent = payrollAmountHolder.getAccumulatedPercent();
        int quotientOne = Math.round(((KualiDecimal)((KualiDecimal)payrollAmount.multiply((AbstractKualiDecimal)KFSConstants.CurrencyTypeAmounts.HUNDRED_DOLLAR_AMOUNT)).divide((AbstractKualiDecimal)totalAmount)).floatValue());
        int quotientTwo = Math.round(((KualiDecimal)((KualiDecimal)accumulatedAmount.multiply((AbstractKualiDecimal)KFSConstants.CurrencyTypeAmounts.HUNDRED_DOLLAR_AMOUNT)).divide((AbstractKualiDecimal)totalAmount)).floatValue());
        payrollAmountHolder.setAccumulatedAmount(accumulatedAmount);
        payrollAmountHolder.setAccumulatedPercent(accumulatedPercent + (quotientTwo -= (accumulatedPercent += quotientOne)));
        payrollAmountHolder.setPayrollPercent(quotientOne + quotientTwo);
    }

    public static KualiDecimal recalculatePayrollAmount(KualiDecimal totalPayrollAmount, Integer effortPercent) {
        double amount = totalPayrollAmount.doubleValue() * (double)effortPercent.intValue() / KFSConstants.CurrencyTypeAmounts.HUNDRED_DOLLAR_AMOUNT.doubleValue();
        return new KualiDecimal(amount);
    }

    public static Double recalculateEffortPercent(KualiDecimal totalPayrollAmount, KualiDecimal payrollAmount) {
        return payrollAmount.doubleValue() * KFSConstants.CurrencyTypeAmounts.HUNDRED_DOLLAR_AMOUNT.doubleValue() / totalPayrollAmount.doubleValue();
    }

    public static String recalculateEffortPercentAsString(KualiDecimal totalPayrollAmount, KualiDecimal payrollAmount) {
        double actualPercentAsDouble = 0.0;
        if (totalPayrollAmount.isNonZero()) {
            actualPercentAsDouble = PayrollAmountHolder.recalculateEffortPercent(totalPayrollAmount, payrollAmount);
        }
        return String.format("%.4f%s", actualPercentAsDouble, "%");
    }
}

