/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.businessobject.inquiry;

import org.kuali.kfs.gl.businessobject.inquiry.AbstractGeneralLedgerInquirableImpl;
import org.kuali.kfs.integration.ld.LaborLedgerBalanceForEffortCertification;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ec.EffortConstants;
import org.kuali.kfs.module.ec.EffortPropertyConstants;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailBuild;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EffortLedgerBalanceInquirableImpl extends AbstractGeneralLedgerInquirableImpl {

    private KualiModuleService kualiModuleService = SpringContext.getBean(KualiModuleService.class);

    @Override
    protected void addMoreParameters(Map<String, String> parameters, String attributeName) {
        BusinessObject businessObject = this.getBusinessObject();
        EffortCertificationDocument document = null;

        if (businessObject instanceof EffortCertificationDetailBuild) {
            EffortCertificationDetailBuild effortCertificationDetail = (EffortCertificationDetailBuild) businessObject;
            document = effortCertificationDetail.getEffortCertificationDocumentBuild();
        } else if (businessObject instanceof EffortCertificationDetail) {
            EffortCertificationDetail effortCertificationDetail = (EffortCertificationDetail) businessObject;
            document = effortCertificationDetail.getEffortCertificationDocument();
        }

        if (document != null) {
            parameters.put(KFSPropertyConstants.UNIVERSITY_FISCAL_YEAR,
                    Objects.toString(document.getUniversityFiscalYear()));
            parameters.put(EffortPropertyConstants.EFFORT_CERTIFICATION_REPORT_NUMBER,
                    document.getEffortCertificationReportNumber());
            parameters.put(KFSPropertyConstants.EMPLID, document.getEmplid());
        }
    }

    @Override
    protected List<String> buildUserDefinedAttributeKeyList() {
        List<String> keys = new ArrayList<>();
        keys.add(KFSPropertyConstants.ACCOUNT_NUMBER);
        keys.add(KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE);
        keys.add(KFSPropertyConstants.SUB_ACCOUNT_NUMBER);
        keys.add(KFSPropertyConstants.FINANCIAL_OBJECT_CODE);
        keys.add(KFSPropertyConstants.POSITION_NUMBER);
        return keys;
    }

    @Override
    protected String getAttributeName(String attributeName) {
        return attributeName;
    }

    @Override
    protected String getBaseUrl() {
        return KFSConstants.GL_BALANCE_INQUIRY_ACTION;
    }

    @Override
    protected Class getInquiryBusinessObjectClass(String attributeName) {
        return kualiModuleService.getResponsibleModuleService(LaborLedgerBalanceForEffortCertification.class)
                .createNewObjectFromExternalizableClass(LaborLedgerBalanceForEffortCertification.class).getClass();
    }

    @Override
    protected String getKeyName(String keyName) {
        return keyName;
    }

    @Override
    protected Object getKeyValue(String keyName, Object keyValue) {
        return keyValue;
    }

    @Override
    protected String getLookupableImplAttributeName() {
        return null;
    }

    @Override
    protected Map<String, Object> getUserDefinedAttributeMap() {
        Map<String, Object> userDefinedAttributeMap = new HashMap<>();

        userDefinedAttributeMap.put(EffortPropertyConstants.EFFORT_CERTIFICATION_PAYROLL_AMOUNT, KualiDecimal.ZERO);
        userDefinedAttributeMap.put(EffortPropertyConstants.EFFORT_CERTIFICATION_ORIGINAL_PAYROLL_AMOUNT,
                KualiDecimal.ZERO);

        return userDefinedAttributeMap;
    }

    @Override
    protected boolean isExclusiveField(Object keyName, Object keyValue) {
        if (super.isExclusiveField(keyName, keyValue)) {
            return true;
        }

        if (keyName != null && keyValue != null) {
            if (keyName.equals(EffortPropertyConstants.SOURCE_ACCOUNT_NUMBER)
                    && keyValue.equals(EffortConstants.DASH_ACCOUNT_NUMBER)) {
                return true;
            } else {
                return keyName.equals(EffortPropertyConstants.SOURCE_CHART_OF_ACCOUNTS_CODE)
                        && keyValue.equals(EffortConstants.DASH_CHART_OF_ACCOUNTS_CODE);
            }
        }
        return false;
    }
}
