/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.businessobject.options;

import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.document.web.struts.CertificationReportForm;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.List;

public class ObjectCodeValuesFinder extends KeyValuesBase {

    public List<KeyValue> getKeyValues() {
        CertificationReportForm form = (CertificationReportForm) KNSGlobalVariables.getKualiForm();
        EffortCertificationDocument document = (EffortCertificationDocument) form.getDocument();
        List<KeyValue> keyValues = new ArrayList<>();
        List<String> objectCodeList = document.getObjectCodeList();
        for (String objectCode : objectCodeList) {
            keyValues.add(new ConcreteKeyValue(objectCode, objectCode));
        }

        return keyValues;
    }

}
