/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.businessobject;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterConstants;
import org.kuali.kfs.kew.actionitem.ActionItemActionListExtension;
import org.kuali.kfs.kew.service.KEWServiceLocator;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.services.KimApiServiceLocator;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;

@ParameterConstants.COMPONENT(component="OutstandingCertificationsByOrganization")
public class OutstandingCertificationsByOrganization
extends EffortCertificationDocument {
    public String getCertificationOrganizations() {
        Object certificationOrganizations = "";
        ArrayList<CallSite> certificationOrganizationList = new ArrayList<CallSite>();
        List<EffortCertificationDetail> details = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            String accountOrg = detailLine.getAccount().getChartOfAccountsCode() + "-" + detailLine.getAccount().getOrganizationCode();
            if (certificationOrganizationList.contains(accountOrg)) continue;
            certificationOrganizationList.add((CallSite)((Object)accountOrg));
            if ("".equals(certificationOrganizations)) {
                certificationOrganizations = accountOrg;
                continue;
            }
            certificationOrganizations = (String)certificationOrganizations + ", " + accountOrg;
        }
        return certificationOrganizations;
    }

    public String getNextApprovers() {
        Object nextApprovers = "";
        Collection actionList = KEWServiceLocator.getActionListService().getActionListForSingleDocument(this.getDocumentHeader().getDocumentNumber());
        for (ActionItemActionListExtension actionItem : actionList) {
            String principalId;
            if (!actionItem.getActionRequestCd().equals("A") || (principalId = actionItem.getPrincipalId()) == null) continue;
            Person person = KimApiServiceLocator.getPersonService().getPerson(actionItem.getPrincipalId());
            if (StringUtils.isBlank((CharSequence)nextApprovers)) {
                nextApprovers = person.getName();
                continue;
            }
            nextApprovers = (String)nextApprovers + "; " + person.getName();
        }
        return nextApprovers;
    }

    public String getEmployeeName() {
        return ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPersonNameByEmployeeId(this.emplid);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof OutstandingCertificationsByOrganization) {
            ArrayList<String> keyFields = new ArrayList<String>();
            keyFields.add("documentNumber");
            ObjectUtil.equals((Object)((Object)this), (Object)arg0, keyFields);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.documentNumber);
    }
}

