/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.businessobject.lookup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.core.api.search.SearchOperator;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.integration.ld.LaborLedgerBalanceForEffortCertification;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.service.EffortCertificationReportDefinitionService;
import org.kuali.kfs.sys.service.OptionsService;

public class EffortLedgerBalanceLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private KualiModuleService kualiModuleService;
    private OptionsService optionsService;
    private EffortCertificationReportDefinitionService effortCertificationReportDefinitionService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        Map<String, String> searchFieldValues = this.getSearchFieldValues(fieldValues);
        List defaultSortColumns = this.getDefaultSortColumns();
        List searchResults = (List)this.getLookupService().findCollectionBySearch(this.getBusinessObjectClass(), searchFieldValues);
        if (defaultSortColumns.size() > 0) {
            searchResults.sort(new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    private Map<String, String> getSearchFieldValues(Map<String, String> fieldValues) {
        String reportYear = fieldValues.get("universityFiscalYear");
        String reportNumber = fieldValues.get("effortCertificationReportNumber");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("universityFiscalYear", reportYear);
        primaryKeys.put("effortCertificationReportNumber", reportNumber);
        EffortCertificationReportDefinition reportDefinition = this.effortCertificationReportDefinitionService.findReportDefinitionByPrimaryKey(primaryKeys);
        HashMap<String, String> searchFieldValues = new HashMap<String, String>(fieldValues);
        searchFieldValues.remove("effortCertificationReportNumber");
        Object fiscalYears = "";
        Object expenseObjectTypeCodes = "";
        for (Integer fiscalYear : reportDefinition.getReportPeriods().keySet()) {
            fiscalYears = (String)fiscalYears + fiscalYear + SearchOperator.OR.op();
            expenseObjectTypeCodes = (String)expenseObjectTypeCodes + this.optionsService.getOptions(fiscalYear).getFinObjTypeExpenditureexpCd() + SearchOperator.OR.op();
        }
        searchFieldValues.put("universityFiscalYear", (String)fiscalYears);
        searchFieldValues.put("financialObjectTypeCode", (String)expenseObjectTypeCodes);
        String balanceTypeCodes = "AC" + SearchOperator.OR.op() + "A2";
        searchFieldValues.put("financialBalanceTypeCode", balanceTypeCodes);
        return searchFieldValues;
    }

    public Class<? extends LaborLedgerBalance> getBusinessObjectClass() {
        return ((LaborLedgerBalanceForEffortCertification)this.kualiModuleService.getResponsibleModuleService(LaborLedgerBalanceForEffortCertification.class).createNewObjectFromExternalizableClass(LaborLedgerBalanceForEffortCertification.class)).getClass();
    }

    public void setEffortCertificationReportDefinitionService(EffortCertificationReportDefinitionService effortCertificationReportDefinitionService) {
        this.effortCertificationReportDefinitionService = effortCertificationReportDefinitionService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }
}

