/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.validation.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.util.LedgerBalanceConsolidationHelper;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.kfs.sys.context.SpringContext;

public final class LedgerBalanceFieldValidator {
    private LedgerBalanceFieldValidator() {
    }

    public static Message hasValidAccount(LaborLedgerBalance ledgerBalance) {
        if (ObjectUtils.isNull((Object)ledgerBalance.getAccount())) {
            String account = ledgerBalance.getChartOfAccountsCode() + ", " + ledgerBalance.getAccountNumber();
            return MessageBuilder.buildMessage((String)"error.effort.accountNumberNotFound", (String)account);
        }
        return null;
    }

    public static Message isInFundGroups(LaborLedgerBalance ledgerBalance, List<String> fundGroupCodes) {
        SubFundGroup subFundGroup = LedgerBalanceFieldValidator.getSubFundGroup(ledgerBalance);
        if (ObjectUtils.isNull((Object)subFundGroup) || !fundGroupCodes.contains(subFundGroup.getFundGroupCode())) {
            return MessageBuilder.buildMessage((String)"error.effort.fundGroupNotFound", (String)subFundGroup.getFundGroupCode());
        }
        return null;
    }

    public static Message isInSubFundGroups(LaborLedgerBalance ledgerBalance, List<String> subFundGroupCodes) {
        SubFundGroup subFundGroup = LedgerBalanceFieldValidator.getSubFundGroup(ledgerBalance);
        if (ObjectUtils.isNull((Object)subFundGroup) || !subFundGroupCodes.contains(subFundGroup.getSubFundGroupCode())) {
            return MessageBuilder.buildMessage((String)"error.effort.fundGroupNotFound", (String)subFundGroup.getSubFundGroupCode());
        }
        return null;
    }

    public static Message isNonZeroAmountBalanceWithinReportPeriod(LaborLedgerBalance ledgerBalance, Map<Integer, Set<String>> reportPeriods) {
        KualiDecimal totalAmount = LedgerBalanceConsolidationHelper.calculateTotalAmountWithinReportPeriod(ledgerBalance, reportPeriods);
        if (totalAmount.isZero()) {
            return MessageBuilder.buildMessage((String)"error.effort.zeroPayrollAmount", (int)1);
        }
        return null;
    }

    public static Message isTotalAmountPositive(Collection<LaborLedgerBalance> ledgerBalances, Map<Integer, Set<String>> reportPeriods) {
        KualiDecimal totalAmount = LedgerBalanceConsolidationHelper.calculateTotalAmountWithinReportPeriod(ledgerBalances, reportPeriods);
        if (!totalAmount.isPositive()) {
            return MessageBuilder.buildMessage((String)"error.effort.nonPositivePayrollAmount", (String)totalAmount.toString());
        }
        return null;
    }

    public static Message hasGrantAccount(Collection<LaborLedgerBalance> ledgerBalances) {
        for (LaborLedgerBalance balance : ledgerBalances) {
            if (!balance.getAccount().isForContractsAndGrants()) continue;
            return null;
        }
        return MessageBuilder.buildMessage((String)"error.effort.notPaidByGrantAccount", (int)1);
    }

    public static Message hasFederalFunds(Collection<LaborLedgerBalance> ledgerBalances, Collection<String> federalAgencyTypeCodes) {
        for (LaborLedgerBalance balance : ledgerBalances) {
            Account account = balance.getAccount();
            if (!((ContractsAndGrantsModuleService)SpringContext.getBean(ContractsAndGrantsModuleService.class)).isAwardedByFederalAgency(account.getChartOfAccountsCode(), account.getAccountNumber(), federalAgencyTypeCodes)) continue;
            return null;
        }
        return MessageBuilder.buildMessage((String)"error.effort.notPaidByFederalFunds", (int)1);
    }

    public static Message isFromSingleOrganization(Collection<LaborLedgerBalance> ledgerBalances) {
        Organization tempOrganization = null;
        boolean isFirstTime = true;
        for (LaborLedgerBalance balance : ledgerBalances) {
            Organization organization = balance.getAccount().getOrganization();
            if (isFirstTime) {
                tempOrganization = organization;
                isFirstTime = false;
            }
            if (organization.equals((Object)tempOrganization)) continue;
            return MessageBuilder.buildMessage((String)"error.effort.multipleOrganizationFound", (int)1);
        }
        return null;
    }

    public static SubFundGroup getSubFundGroup(LaborLedgerBalance ledgerBalance) {
        SubFundGroup subFundGroup;
        try {
            subFundGroup = ledgerBalance.getAccount().getSubFundGroup();
        }
        catch (NullPointerException npe) {
            return null;
        }
        return subFundGroup;
    }
}

