/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.integration.ec.EffortCertificationModuleService;
import org.kuali.kfs.integration.ec.EffortCertificationReport;
import org.kuali.kfs.module.ec.EffortConstants;
import org.kuali.kfs.module.ec.dataaccess.EffortCertificationReportDefinitionDao;
import org.kuali.kfs.module.ec.service.EffortCertificationReportDefinitionService;
import org.kuali.kfs.module.ec.util.AccountingPeriodMonth;
import org.kuali.kfs.module.ec.util.EffortCertificationParameterFinder;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationModuleServiceImpl
implements EffortCertificationModuleService {
    private EffortCertificationReportDefinitionDao effortCertificationReportDefinitionDao;
    private EffortCertificationReportDefinitionService effortCertificationReportDefinitionService;

    public List<EffortCertificationReport> findReportDefinitionsForPeriod(Integer fiscalYear, String periodCode, String positionObjectGroupCode) {
        List<EffortCertificationReport> effortCertificationReports = this.effortCertificationReportDefinitionDao.getAllByYearAndPositionCode(fiscalYear, positionObjectGroupCode);
        ArrayList<EffortCertificationReport> reportsContainingPeriod = new ArrayList<EffortCertificationReport>();
        for (EffortCertificationReport report : effortCertificationReports) {
            Map<Integer, Set<String>> reportPeriods = AccountingPeriodMonth.findAccountingPeriodsBetween(report.getEffortCertificationReportBeginFiscalYear(), report.getEffortCertificationReportBeginPeriodCode(), report.getEffortCertificationReportEndFiscalYear(), report.getEffortCertificationReportEndPeriodCode());
            Set<String> periodsForYear = reportPeriods.get(fiscalYear);
            if (!periodsForYear.contains(periodCode)) continue;
            reportsContainingPeriod.add(report);
        }
        return reportsContainingPeriod;
    }

    public EffortCertificationReport isEmployeeWithOpenCertification(List<EffortCertificationReport> effortCertificationReports, String emplid) {
        for (EffortCertificationReport report : effortCertificationReports) {
            if (!this.effortCertificationReportDefinitionService.hasBeenUsedForEffortCertificationGeneration(emplid, report)) continue;
            return report;
        }
        return null;
    }

    public List<String> getCostShareSubAccountTypeCodes() {
        return EffortConstants.ELIGIBLE_COST_SHARE_SUB_ACCOUNT_TYPE_CODES;
    }

    public boolean isFederalOnlyBalanceIndicator() {
        return EffortCertificationParameterFinder.getFederalOnlyBalanceIndicator();
    }

    public void setEffortCertificationReportDefinitionDao(EffortCertificationReportDefinitionDao effortCertificationReportDefinitionDao) {
        this.effortCertificationReportDefinitionDao = effortCertificationReportDefinitionDao;
    }

    public void setEffortCertificationReportDefinitionService(EffortCertificationReportDefinitionService effortCertificationReportDefinitionService) {
        this.effortCertificationReportDefinitionService = effortCertificationReportDefinitionService;
    }
}

