/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ec.batch.EffortCertificationCreateStep;
import org.kuali.kfs.module.ec.batch.EffortCertificationExtractStep;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public final class EffortCertificationParameterFinder {
    private static ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);

    private EffortCertificationParameterFinder() {
    }

    public static boolean getRunIndicator() {
        return parameterService.getParameterValueAsBoolean(EffortCertificationExtractStep.class, "RUN_IND");
    }

    public static Collection<String> getFederalAgencyTypeCodes() {
        return parameterService.getParameterValuesAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "FEDERAL_AGENCY_TYPE");
    }

    public static boolean getFederalOnlyBalanceIndicator() {
        return parameterService.getParameterValueAsBoolean(EffortCertificationExtractStep.class, "FEDERAL_ONLY_BALANCE_IND");
    }

    public static boolean getFederalOnlyRouteIndicator() {
        return parameterService.getParameterValueAsBoolean(EffortCertificationDocument.class, "FEDERAL_ONLY_ROUTE_IND");
    }

    public static List<String> getFederalOnlyBalanceIndicatorAsString() {
        ArrayList<String> indicatorList = new ArrayList<String>();
        indicatorList.add(Boolean.toString(EffortCertificationParameterFinder.getFederalOnlyBalanceIndicator()));
        return indicatorList;
    }

    public static Collection<String> getAccountTypeCodes() {
        return parameterService.getParameterValuesAsString(EffortCertificationExtractStep.class, "ACCOUNT_TYPE_CODE_BALANCE_SELECT");
    }

    public static Integer getExtractReportFiscalYear() {
        return Integer.valueOf(parameterService.getParameterValueAsString(EffortCertificationExtractStep.class, "RUN_FISCAL_YEAR"));
    }

    public static String getExtractReportNumber() {
        return parameterService.getParameterValueAsString(EffortCertificationExtractStep.class, "RUN_REPORT_NUMBER");
    }

    public static Integer getCreateReportFiscalYear() {
        return Integer.valueOf(parameterService.getParameterValueAsString(EffortCertificationCreateStep.class, "CREATE_FISCAL_YEAR"));
    }

    public static String getCreateReportNumber() {
        return parameterService.getParameterValueAsString(EffortCertificationCreateStep.class, "CREATE_REPORT_NUMBER");
    }
}

