/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.document.service;

import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.dataaccess.EffortCertificationReportDefinitionDao;

import java.util.List;

/**
 * Contains service methods for the Effort Certification Automatic Period Update Process
 */
public interface EffortCertificationAutomaticReportPeriodUpdateService {

    /**
     * @param reportDefinition
     * @return true reportDefinition is an overlapping report definition
     */
    boolean isAnOverlappingReportDefinition(EffortCertificationReportDefinition reportDefinition);

    /**
     * @return list of EffortCertificationReportDefinition records
     */
    List<EffortCertificationReportDefinition> getAllReportDefinitions();

    void setEffortCertificationReportDefinitionDao(
            EffortCertificationReportDefinitionDao effortCertificationReportDefinitionDao);
}
