/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.businessobject.options;

import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationPeriodStatusCode;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.core.api.util.ConcreteKeyValue;
import org.kuali.kfs.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PeriodStatusCodeValuesFinder extends KeyValuesBase {

    private static final String EFFORT_CERTIFICATION_REPORT_PERIOD_STATUS_CODE =
            "effortCertificationReportPeriodStatusCode";
    private BusinessObjectService businessObjectService;

    @Override
    public List<KeyValue> getKeyValues() {
        final Collection<EffortCertificationPeriodStatusCode> statusCodes =
                businessObjectService.findAllOrderBy(EffortCertificationPeriodStatusCode.class,
                        EFFORT_CERTIFICATION_REPORT_PERIOD_STATUS_CODE, true);

        final List<KeyValue> keyValues = new ArrayList<>();
        keyValues.add(new ConcreteKeyValue(KFSConstants.EMPTY_STRING, KFSConstants.EMPTY_STRING));
        for (final EffortCertificationPeriodStatusCode statusCode : statusCodes) {
            keyValues.add(new ConcreteKeyValue(statusCode.getEffortCertificationReportPeriodStatusCode(),
                    statusCode.getEffortCertificationReportPeriodStatusCode() + " - " +
                    statusCode.getEffortCertificationReportPeriodStatusDescription()));
        }
        return keyValues;
    }

    public void setBusinessObjectService(final BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}
