/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.document.web.struts;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.module.ec.EffortPropertyConstants;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.sys.DynamicCollectionComparator.SortOrder;
import org.kuali.kfs.sys.context.SpringContext;

import java.sql.Date;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/**
 * Action form for Effort Certification Document.
 */
public class CertificationReportForm extends EffortCertificationForm {

    private static final Logger LOG = LogManager.getLogger();
    protected static transient AccountingPeriodService accountingPeriodService;

    protected String sortOrder = SortOrder.ASC.name();

    public String getSortOrder() {
        return sortOrder;
    }

    public static AccountingPeriodService getAccountingPeriodService() {
        if (accountingPeriodService == null) {
            accountingPeriodService = SpringContext.getBean(AccountingPeriodService.class);
        }
        return accountingPeriodService;
    }

    public void setSortOrder(final String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Date getReportPeriodBeginDate() {
        final EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument) getDocument();
        effortCertificationDocument.refreshReferenceObject(
                EffortPropertyConstants.EFFORT_CERTIFICATION_REPORT_DEFINITION);
        final AccountingPeriod beginPeriod = effortCertificationDocument.getEffortCertificationReportDefinition()
                .getReportBeginPeriod();
        final AccountingPeriod previousPeriod = getAccountingPeriodService().getPreviousAccountingPeriod(beginPeriod);
        return getUniversityFiscalPeriodBeginDate(previousPeriod);
    }

    public Date getReportPeriodEndDate() {
        final EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument) getDocument();
        effortCertificationDocument.refreshReferenceObject(
                EffortPropertyConstants.EFFORT_CERTIFICATION_REPORT_DEFINITION);
        final AccountingPeriod endPeriod = effortCertificationDocument.getEffortCertificationReportDefinition()
                .getReportEndPeriod();
        return endPeriod.getUniversityFiscalPeriodEndDate();
    }

    /**
     * @return Returns the universityFiscalPeriodBeginDate. The begin date is the first day after the previous
     *         period's end date.
     */
    protected Date getUniversityFiscalPeriodBeginDate(final AccountingPeriod previousAccountingPeriod) {
        final Calendar calendar = Calendar.getInstance();
        calendar.setTime(previousAccountingPeriod .getUniversityFiscalPeriodEndDate());
        calendar.add(Calendar.DATE, 1);
        return new Date(calendar.getTime().getTime());
    }

    public List<EffortCertificationDetail> getSummarizedDetailLines() {
        final EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument) getDocument();
        return effortCertificationDocument.getSummarizedDetailLines();
    }

    public List<Map<String, HtmlData>> getSummarizedDetailLineFieldInquiryUrl() {
        LOG.debug("getSummarizedDetailLineFieldInquiryUrl() start");
        return getDetailLineFieldInquiryUrl(getSummarizedDetailLines());
    }

    public List<Map<String, String>> getSummarizedDetailLineFieldInfo() {
        LOG.debug("getSummarizedDetailLineFieldInfo() start");
        return getFieldInfo(getSummarizedDetailLines());
    }
}
