/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.batch;

import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.ec.batch.service.EffortCertificationExtractService;
import org.kuali.kfs.module.ec.util.EffortCertificationParameterFinder;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.kfs.sys.service.MessageBuilderService;

public class EffortCertificationExtractStep
extends AbstractStep {
    private static final Logger LOG = LogManager.getLogger();
    private EffortCertificationExtractService effortCertificationExtractService;
    private MessageBuilderService messageBuilderService;

    public boolean execute(String jobName, Date jobRunDate) {
        if (EffortCertificationParameterFinder.getRunIndicator()) {
            this.effortCertificationExtractService.extract();
        } else {
            String key = "error.effort.batchJobNotScheduled";
            String message = this.messageBuilderService.buildMessageWithPlaceHolder("error.effort.batchJobNotScheduled", 0, new Object[]{jobName, "RUN_IND"}).toString();
            LOG.warn(message);
        }
        return true;
    }

    public void setEffortCertificationExtractService(EffortCertificationExtractService effortCertificationExtractService) {
        this.effortCertificationExtractService = effortCertificationExtractService;
    }

    public void setMessageBuilderService(MessageBuilderService messageBuilderService) {
        this.messageBuilderService = messageBuilderService;
    }
}

