/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.batch.service.impl;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ec.batch.service.EffortCertificationCreateService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentService;
import org.kuali.kfs.module.ec.util.EffortCertificationParameterFinder;
import org.kuali.kfs.sys.service.MessageBuilderService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationCreateServiceImpl
implements EffortCertificationCreateService {
    private static final Logger LOG = LogManager.getLogger();
    private BusinessObjectService businessObjectService;
    private EffortCertificationDocumentService effortCertificationDocumentService;
    private MessageBuilderService messageBuilderService;

    @Override
    public void create() {
        Integer fiscalYear = EffortCertificationParameterFinder.getCreateReportFiscalYear();
        String reportNumber = EffortCertificationParameterFinder.getCreateReportNumber();
        this.create(fiscalYear, reportNumber);
    }

    @Override
    public void create(Integer fiscalYear, String reportNumber) {
        Map<String, String> fieldValues = EffortCertificationReportDefinition.buildKeyMap(fiscalYear, reportNumber);
        String errorMessage = this.validateReportDefinition(fieldValues);
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            LOG.fatal(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        Collection documentsBuild = this.businessObjectService.findMatching(EffortCertificationDocumentBuild.class, fieldValues);
        for (EffortCertificationDocumentBuild documentBuild : documentsBuild) {
            boolean isCreated = this.effortCertificationDocumentService.createAndRouteEffortCertificationDocument(documentBuild);
            if (!isCreated) continue;
            this.businessObjectService.delete((PersistableBusinessObject)documentBuild);
        }
    }

    protected String validateReportDefinition(Map<String, String> fieldValues) {
        String fiscalYear = fieldValues.get("universityFiscalYear");
        String reportNumber = fieldValues.get("effortCertificationReportNumber");
        String combinedFieldValues = fiscalYear + ", " + reportNumber;
        if (StringUtils.isEmpty((CharSequence)fiscalYear)) {
            return this.messageBuilderService.buildMessage("error.effort.fiscalYearMissing", null).getMessage();
        }
        if (StringUtils.isEmpty((CharSequence)reportNumber)) {
            return this.messageBuilderService.buildMessage("error.effort.reportNumberMissing", null).getMessage();
        }
        EffortCertificationReportDefinition reportDefinition = (EffortCertificationReportDefinition)this.businessObjectService.findByPrimaryKey(EffortCertificationReportDefinition.class, fieldValues);
        if (reportDefinition == null) {
            return this.messageBuilderService.buildMessage("error.effort.fiscalYearOrReportNumberInvalid", combinedFieldValues).getMessage();
        }
        if (!reportDefinition.isActive()) {
            return this.messageBuilderService.buildMessage("error.effort.reportDefinitionInactive", combinedFieldValues).getMessage();
        }
        if (!"O".equals(reportDefinition.getEffortCertificationReportPeriodStatusCode())) {
            return this.messageBuilderService.buildMessage("error.effort.reportDefinitionPeriodNotOpened", combinedFieldValues).getMessage();
        }
        int countOfDocuments = this.businessObjectService.countMatching(EffortCertificationDocument.class, fieldValues);
        if (countOfDocuments > 0) {
            return this.messageBuilderService.buildMessageWithPlaceHolder("error.effort.reportDocumentExist", 1, new Object[]{reportNumber, fiscalYear}).getMessage();
        }
        int countOfDocumentsBuild = this.businessObjectService.countMatching(EffortCertificationDocumentBuild.class, fieldValues);
        if (countOfDocumentsBuild <= 0) {
            return this.messageBuilderService.buildMessageWithPlaceHolder("error.effort.reportDocumentBuildNotExist", 1, new Object[]{reportNumber, fiscalYear}).getMessage();
        }
        return null;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setEffortCertificationDocumentService(EffortCertificationDocumentService effortCertificationDocumentService) {
        this.effortCertificationDocumentService = effortCertificationDocumentService;
    }

    public void setMessageBuilderService(MessageBuilderService messageBuilderService) {
        this.messageBuilderService = messageBuilderService;
    }
}

