/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.web.struts;

import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.document.web.struts.EffortCertificationForm;
import org.kuali.kfs.sys.DynamicCollectionComparator;
import org.kuali.kfs.sys.context.SpringContext;

public class CertificationReportForm
extends EffortCertificationForm {
    private static final Logger LOG = LogManager.getLogger();
    protected static transient AccountingPeriodService accountingPeriodService;
    protected String sortOrder = DynamicCollectionComparator.SortOrder.ASC.name();
    private DateTimeService dateTimeService;

    public String getSortOrder() {
        return this.sortOrder;
    }

    public static AccountingPeriodService getAccountingPeriodService() {
        if (accountingPeriodService == null) {
            accountingPeriodService = (AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class);
        }
        return accountingPeriodService;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Date getReportPeriodBeginDate() {
        EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument)this.getDocument();
        effortCertificationDocument.refreshReferenceObject("effortCertificationReportDefinition");
        AccountingPeriod beginPeriod = effortCertificationDocument.getEffortCertificationReportDefinition().getReportBeginPeriod();
        AccountingPeriod previousPeriod = CertificationReportForm.getAccountingPeriodService().getPreviousAccountingPeriod(beginPeriod);
        return this.getUniversityFiscalPeriodBeginDate(previousPeriod);
    }

    public Date getReportPeriodEndDate() {
        EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument)this.getDocument();
        effortCertificationDocument.refreshReferenceObject("effortCertificationReportDefinition");
        AccountingPeriod endPeriod = effortCertificationDocument.getEffortCertificationReportDefinition().getReportEndPeriod();
        return endPeriod.getUniversityFiscalPeriodEndDate();
    }

    protected Date getUniversityFiscalPeriodBeginDate(AccountingPeriod previousAccountingPeriod) {
        LocalDate localDate = this.getDateTimeService().getLocalDate(previousAccountingPeriod.getUniversityFiscalPeriodEndDate()).plusDays(1L);
        return this.getDateTimeService().getSqlDate(localDate);
    }

    public List<EffortCertificationDetail> getSummarizedDetailLines() {
        EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument)this.getDocument();
        return effortCertificationDocument.getSummarizedDetailLines();
    }

    public List<Map<String, HtmlData>> getSummarizedDetailLineFieldInquiryUrl() {
        LOG.debug("getSummarizedDetailLineFieldInquiryUrl() start");
        return this.getDetailLineFieldInquiryUrl(this.getSummarizedDetailLines());
    }

    public List<Map<String, String>> getSummarizedDetailLineFieldInfo() {
        LOG.debug("getSummarizedDetailLineFieldInfo() start");
        return this.getFieldInfo(this.getSummarizedDetailLines());
    }
}

