/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.web.struts;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailLineOverride;
import org.kuali.kfs.module.ec.businessobject.inquiry.EffortLedgerBalanceInquirableImpl;
import org.kuali.kfs.module.ec.businessobject.inquiry.EffortPositionDataDetailsInquirableImpl;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.util.PayrollAmountHolder;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentFormBase;

public class EffortCertificationForm
extends FinancialSystemTransactionalDocumentFormBase {
    private static final Logger LOG = LogManager.getLogger();
    protected EffortCertificationDetail newDetailLine;

    public EffortCertificationForm() {
        this.setNewDetailLine(this.createNewDetailLine());
    }

    protected String getDefaultDocumentTypeName() {
        return "ECD";
    }

    public EffortCertificationDetail createNewDetailLine() {
        EffortCertificationDetail detailLine = new EffortCertificationDetail();
        detailLine.setEffortCertificationUpdatedOverallPercent(null);
        detailLine.setEffortCertificationPayrollAmount(null);
        detailLine.setSubAccountNumber(null);
        return detailLine;
    }

    public EffortCertificationDetail getNewDetailLine() {
        return this.newDetailLine;
    }

    public void setNewDetailLine(EffortCertificationDetail newDetailLine) {
        this.newDetailLine = newDetailLine;
    }

    public EffortCertificationDocument getEffortCertificationDocument() {
        return (EffortCertificationDocument)this.getDocument();
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        for (EffortCertificationDetail detailLine : this.getDetailLines()) {
            EffortCertificationDetailLineOverride.populateFromInput(detailLine);
        }
    }

    public List<EffortCertificationDetail> getDetailLines() {
        EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument)this.getDocument();
        return effortCertificationDocument.getEffortCertificationDetailLines();
    }

    public Map<String, DataObjectRelationship> getRelationshipMetadata() {
        LOG.debug("getRelationshipMetadata() start");
        PersistenceStructureService persistenceStructureService = (PersistenceStructureService)SpringContext.getBean(PersistenceStructureService.class);
        HashMap<String, DataObjectRelationship> relationshipMetadata = new HashMap<String, DataObjectRelationship>();
        for (String attributeName : this.getInquirableFieldNames()) {
            Map primitiveReference = LookupUtils.getPrimitiveReference((BusinessObject)this.newDetailLine, (String)attributeName);
            if (primitiveReference == null || primitiveReference.isEmpty()) continue;
            DataObjectRelationship primitiveRelationship = this.getPrimitiveDataObjectRelationship(persistenceStructureService.getRelationshipMetadata(((Object)((Object)this.newDetailLine)).getClass(), attributeName));
            relationshipMetadata.put(attributeName, primitiveRelationship);
        }
        return relationshipMetadata;
    }

    public List<Map<String, HtmlData>> getDetailLineFieldInquiryUrl() {
        LOG.debug("getDetailLineFieldInquiryUrl() start");
        return this.getDetailLineFieldInquiryUrl(this.getDetailLines());
    }

    protected List<Map<String, HtmlData>> getDetailLineFieldInquiryUrl(List<EffortCertificationDetail> detailLines) {
        LOG.debug("getDetailLineFieldInquiryUrl(List<EffortCertificationDetail>) start");
        Map<String, String> noninquirableFieldValues = this.getNoninquirableFieldValues();
        Inquirable inquirable = this.getInquirable();
        ArrayList<Map<String, HtmlData>> inquiryURL = new ArrayList<Map<String, HtmlData>>();
        for (EffortCertificationDetail detailLine : detailLines) {
            detailLine.refreshNonUpdateableReferences();
            HashMap<String, HtmlData> inquiryURLForAttribute = new HashMap<String, HtmlData>();
            for (String attributeName : this.getInquirableFieldNames()) {
                Object attributeValue = ObjectUtils.getPropertyValue((Object)((Object)detailLine), (String)attributeName);
                String noninquirableFieldValue = noninquirableFieldValues.get(attributeName);
                if (noninquirableFieldValue != null && noninquirableFieldValue.equals(attributeValue)) continue;
                HtmlData inquiryHref = this.getCustomizedInquirableFieldNames().contains(attributeName) ? this.getCustomizedInquiryUrl(detailLine, attributeName) : inquirable.getInquiryUrl((BusinessObject)detailLine, attributeName, false);
                inquiryURLForAttribute.put(attributeName, inquiryHref);
            }
            inquiryURL.add(inquiryURLForAttribute);
        }
        return inquiryURL;
    }

    public List<Map<String, String>> getFieldInfo() {
        LOG.debug("getFieldInfo() start");
        return this.getFieldInfo(this.getDetailLines());
    }

    protected Map<String, String> getFieldInfo(EffortCertificationDetail detailLine) {
        Chart sourceChart;
        Account sourceAccount;
        ObjectCode objectCode;
        LOG.info("getFieldInfo(List<EffortCertificationDetail>) start");
        EffortCertificationDocument document = (EffortCertificationDocument)this.getDocument();
        KualiDecimal totalOriginalPayrollAmount = document.getTotalOriginalPayrollAmount();
        detailLine.refreshNonUpdateableReferences();
        HashMap<String, String> fieldInfoForAttribute = new HashMap<String, String>();
        fieldInfoForAttribute.put("chartOfAccountsCode", ObjectUtils.isNotNull((Object)detailLine.getChartOfAccounts()) ? detailLine.getChartOfAccounts().getFinChartOfAccountDescription() : "");
        String accountInfo = EffortCertificationForm.buildAccountInfo(detailLine.getAccount());
        fieldInfoForAttribute.put("accountNumber", accountInfo);
        SubAccount subAccount = detailLine.getSubAccount();
        if (ObjectUtils.isNotNull((Object)subAccount)) {
            fieldInfoForAttribute.put("subAccountNumber", subAccount.getSubAccountName());
        }
        if (ObjectUtils.isNotNull((Object)(objectCode = detailLine.getFinancialObject()))) {
            fieldInfoForAttribute.put("financialObjectCode", objectCode.getFinancialObjectCodeName());
        }
        if (ObjectUtils.isNotNull((Object)(sourceAccount = detailLine.getSourceAccount()))) {
            fieldInfoForAttribute.put("sourceAccountNumber", sourceAccount.getAccountName());
        }
        if (ObjectUtils.isNotNull((Object)(sourceChart = detailLine.getSourceChartOfAccounts()))) {
            fieldInfoForAttribute.put("sourceChartOfAccountsCode", sourceChart.getFinChartOfAccountDescription());
        }
        KualiDecimal originalPayrollAmount = detailLine.getEffortCertificationOriginalPayrollAmount();
        String actualOriginalPercent = PayrollAmountHolder.recalculateEffortPercentAsString(totalOriginalPayrollAmount, originalPayrollAmount);
        fieldInfoForAttribute.put("effortCertificationCalculatedOverallPercent", actualOriginalPercent);
        return fieldInfoForAttribute;
    }

    protected List<Map<String, String>> getFieldInfo(List<EffortCertificationDetail> detailLines) {
        LOG.debug("getFieldInfo(List<EffortCertificationDetail>) start");
        ArrayList<Map<String, String>> fieldInfo = new ArrayList<Map<String, String>>();
        EffortCertificationDocument document = (EffortCertificationDocument)this.getDocument();
        KualiDecimal totalOriginalPayrollAmount = document.getTotalOriginalPayrollAmount();
        for (EffortCertificationDetail detailLine : detailLines) {
            Chart sourceChart;
            Account sourceAccount;
            ObjectCode objectCode;
            detailLine.refreshNonUpdateableReferences();
            HashMap<String, String> fieldInfoForAttribute = new HashMap<String, String>();
            fieldInfoForAttribute.put("chartOfAccountsCode", detailLine.getChartOfAccounts().getFinChartOfAccountDescription());
            String accountInfo = EffortCertificationForm.buildAccountInfo(detailLine.getAccount());
            fieldInfoForAttribute.put("accountNumber", accountInfo);
            SubAccount subAccount = detailLine.getSubAccount();
            if (ObjectUtils.isNotNull((Object)subAccount)) {
                fieldInfoForAttribute.put("subAccountNumber", subAccount.getSubAccountName());
            }
            if (ObjectUtils.isNotNull((Object)(objectCode = detailLine.getFinancialObject()))) {
                fieldInfoForAttribute.put("financialObjectCode", objectCode.getFinancialObjectCodeName());
            }
            if (ObjectUtils.isNotNull((Object)(sourceAccount = detailLine.getSourceAccount()))) {
                fieldInfoForAttribute.put("sourceAccountNumber", sourceAccount.getAccountName());
            }
            if (ObjectUtils.isNotNull((Object)(sourceChart = detailLine.getSourceChartOfAccounts()))) {
                fieldInfoForAttribute.put("sourceChartOfAccountsCode", sourceChart.getFinChartOfAccountDescription());
            }
            KualiDecimal originalPayrollAmount = detailLine.getEffortCertificationOriginalPayrollAmount();
            String actualOriginalPercent = PayrollAmountHolder.recalculateEffortPercentAsString(totalOriginalPayrollAmount, originalPayrollAmount);
            fieldInfoForAttribute.put("effortCertificationCalculatedOverallPercent", actualOriginalPercent);
            fieldInfo.add(fieldInfoForAttribute);
        }
        return fieldInfo;
    }

    protected DataObjectRelationship getPrimitiveDataObjectRelationship(Map<String, DataObjectRelationship> relationshipMetadata) {
        int minCountOfKeys = Integer.MAX_VALUE;
        DataObjectRelationship primitiveRelationship = null;
        for (String attribute : relationshipMetadata.keySet()) {
            DataObjectRelationship currentRelationship = relationshipMetadata.get(attribute);
            Map parentToChildReferences = currentRelationship.getParentToChildReferences();
            if (parentToChildReferences.size() >= minCountOfKeys) continue;
            minCountOfKeys = parentToChildReferences.size();
            primitiveRelationship = currentRelationship;
        }
        return primitiveRelationship;
    }

    protected HtmlData getCustomizedInquiryUrl(EffortCertificationDetail detailLine, String attributeName) {
        if (StringUtils.equals((CharSequence)attributeName, (CharSequence)"positionNumber")) {
            HtmlData.AnchorHtmlData inquiryHref = (HtmlData.AnchorHtmlData)this.getEffortPositionDataDetailsInquirableImpl().getInquiryUrl((BusinessObject)detailLine, attributeName);
            inquiryHref.setHref(this.getCompleteURL(inquiryHref.getHref()));
            return inquiryHref;
        }
        HtmlData.AnchorHtmlData inquiryHref = (HtmlData.AnchorHtmlData)this.getInquirable().getInquiryUrl((BusinessObject)detailLine, attributeName, false);
        inquiryHref.setHref(this.getCompleteURL(inquiryHref.getHref()));
        return inquiryHref;
    }

    public Map<String, String> getNoninquirableFieldValues() {
        HashMap<String, String> inquirableFieldNames = new HashMap<String, String>();
        inquirableFieldNames.put("subAccountNumber", KFSConstants.getDashSubAccountNumber());
        inquirableFieldNames.put("financialObjectCode", KFSConstants.getDashFinancialObjectCode());
        inquirableFieldNames.put("positionNumber", "--------");
        inquirableFieldNames.put("sourceChartOfAccountsCode", "--");
        inquirableFieldNames.put("sourceAccountNumber", "-------");
        inquirableFieldNames.put("costShareSourceSubAccountNumber", KFSConstants.getDashSubAccountNumber());
        return inquirableFieldNames;
    }

    public List<String> getInquirableFieldNames() {
        ArrayList<String> inquirableFieldNames = new ArrayList<String>();
        inquirableFieldNames.add("chartOfAccountsCode");
        inquirableFieldNames.add("accountNumber");
        inquirableFieldNames.add("subAccountNumber");
        inquirableFieldNames.add("financialObjectCode");
        inquirableFieldNames.add("positionNumber");
        inquirableFieldNames.add("sourceChartOfAccountsCode");
        inquirableFieldNames.add("sourceAccountNumber");
        inquirableFieldNames.add("costShareSourceSubAccountNumber");
        inquirableFieldNames.add("effortCertificationOriginalPayrollAmount");
        inquirableFieldNames.add("effortCertificationPayrollAmount");
        return inquirableFieldNames;
    }

    public List<String> getCustomizedInquirableFieldNames() {
        ArrayList<String> inquirableFieldNames = new ArrayList<String>();
        inquirableFieldNames.add("positionNumber");
        inquirableFieldNames.add("effortCertificationOriginalPayrollAmount");
        inquirableFieldNames.add("effortCertificationPayrollAmount");
        return inquirableFieldNames;
    }

    protected String getCompleteURL(String baseURL) {
        if (StringUtils.isBlank((CharSequence)baseURL)) {
            return baseURL;
        }
        String completeURL = baseURL;
        EffortCertificationDocument document = (EffortCertificationDocument)this.getDocument();
        Properties properties = new Properties();
        properties.put("emplid", document.getEmplid());
        properties.put("effortCertificationReportNumber", document.getEffortCertificationReportNumber());
        properties.put("universityFiscalYear", document.getUniversityFiscalYear());
        StringBuilder queryString = new StringBuilder();
        for (Object key : properties.keySet()) {
            queryString.append("&").append(key).append("=").append(properties.get(key));
        }
        return completeURL.concat(queryString.toString());
    }

    public Map<String, String> getDetailLineFieldInfo() {
        LOG.info("getSummarizedDetailLineFieldInfo() start");
        return this.getFieldInfo(this.getNewDetailLine());
    }

    protected Inquirable getInquirable() {
        return new EffortLedgerBalanceInquirableImpl();
    }

    protected EffortPositionDataDetailsInquirableImpl getEffortPositionDataDetailsInquirableImpl() {
        return new EffortPositionDataDetailsInquirableImpl();
    }

    public static String buildAccountInfo(Account account) {
        if (ObjectUtils.isNull((Object)account)) {
            return "";
        }
        String projectDirectorName = "";
        try {
            ContractsAndGrantsModuleService contractsAndGrantsModuleService = (ContractsAndGrantsModuleService)SpringContext.getBean(ContractsAndGrantsModuleService.class);
            Person projectDirector = contractsAndGrantsModuleService.getProjectDirectorForAccount(account);
            projectDirectorName = projectDirector != null ? MessageFormat.format("  ({0})", projectDirector.getName()) : "";
        }
        catch (Exception e) {
            LOG.error("Cannot find a project director for the account:{}", (Object)account);
        }
        return MessageFormat.format("{0}{1}", account.getAccountName(), projectDirectorName);
    }

    public static String loadAccountInfo(String chartOfAccountsCode, String accountNumber) {
        Account account = ((AccountService)SpringContext.getBean(AccountService.class)).getByPrimaryIdWithCaching(chartOfAccountsCode, accountNumber);
        return EffortCertificationForm.buildAccountInfo(account);
    }
}

