/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service.impl;

import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import org.kuali.kfs.module.ec.service.EffortCertificationReportService;
import org.kuali.kfs.module.ec.util.ExtractProcessReportDataHolder;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationReportServiceImpl
implements EffortCertificationReportService {
    private ReportGenerationService reportGenerationService;
    private ReportInfo effortExtractProcessReportInfo;

    @Override
    public void generateReportForExtractProcess(ExtractProcessReportDataHolder reportDataHolder, Date runDate) {
        String reportFileName = this.effortExtractProcessReportInfo.getReportFileName();
        String reportDirectory = this.effortExtractProcessReportInfo.getReportsDirectory();
        String reportTemplateClassPath = this.effortExtractProcessReportInfo.getReportTemplateClassPath();
        String reportTemplateName = this.effortExtractProcessReportInfo.getReportTemplateName();
        ResourceBundle resourceBundle = this.effortExtractProcessReportInfo.getResourceBundle();
        String subReportTemplateClassPath = this.effortExtractProcessReportInfo.getSubReportTemplateClassPath();
        Map subReports = this.effortExtractProcessReportInfo.getSubReports();
        Map<String, Object> reportData = reportDataHolder.getReportData();
        reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        reportData.put("SUBREPORT_DIR", subReportTemplateClassPath);
        reportData.put("SUBREPORT_TEMPLATE_NAMES", subReports);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = this.reportGenerationService.buildFullFileName(runDate, reportDirectory, reportFileName, "");
        this.reportGenerationService.generateReportToPdfFile(reportData, template, fullReportFileName);
    }

    public void setEffortExtractProcessReportInfo(ReportInfo effortExtractProcessReportInfo) {
        this.effortExtractProcessReportInfo = effortExtractProcessReportInfo;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }
}

