/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public final class EffortCertificationParameterFinder {
    private static ParameterService parameterService;

    private EffortCertificationParameterFinder() {
    }

    public static boolean getRunIndicator() {
        return EffortCertificationParameterFinder.getParameterService().getParameterValueAsBoolean("KFS-EC", "EffortCertification", "RUN_IND");
    }

    public static Collection<String> getFederalAgencyTypeCodes() {
        return EffortCertificationParameterFinder.getParameterService().getParameterValuesAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "FEDERAL_AGENCY_TYPE");
    }

    public static boolean getFederalOnlyBalanceIndicator() {
        return EffortCertificationParameterFinder.getParameterService().getParameterValueAsBoolean("KFS-EC", "EffortCertification", "FEDERAL_ACCOUNT_IND");
    }

    public static boolean getFederalOnlyRouteIndicator() {
        return EffortCertificationParameterFinder.getParameterService().getParameterValueAsBoolean("KFS-EC", "EffortCertification", "FEDERAL_ROUTE_IND");
    }

    public static List<String> getFederalOnlyBalanceIndicatorAsString() {
        ArrayList<String> indicatorList = new ArrayList<String>();
        indicatorList.add(Boolean.toString(EffortCertificationParameterFinder.getFederalOnlyBalanceIndicator()));
        return indicatorList;
    }

    public static Collection<String> getAccountTypeCodes() {
        return EffortCertificationParameterFinder.getParameterService().getParameterValuesAsString("KFS-EC", "EffortCertification", "ACCOUNT_TYPES");
    }

    public static Integer getExtractReportFiscalYear() {
        return Integer.valueOf(EffortCertificationParameterFinder.getParameterService().getParameterValueAsString("KFS-EC", "EffortCertification", "EXTRACT_FISCAL_YEAR"));
    }

    public static String getExtractReportNumber() {
        return EffortCertificationParameterFinder.getParameterService().getParameterValueAsString("KFS-EC", "EffortCertification", "EXTRACT_REPORT_NUMBER");
    }

    public static Integer getCreateReportFiscalYear() {
        return Integer.valueOf(EffortCertificationParameterFinder.getParameterService().getParameterValueAsString("KFS-EC", "EffortCertification", "CREATE_FISCAL_YEAR"));
    }

    public static String getCreateReportNumber() {
        return EffortCertificationParameterFinder.getParameterService().getParameterValueAsString("KFS-EC", "EffortCertification", "CREATE_REPORT_NUMBER");
    }

    private static ParameterService getParameterService() {
        if (parameterService == null) {
            parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        }
        return parameterService;
    }
}

