/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.util.LedgerBalanceWithMessage;

public class ExtractProcessReportDataHolder {
    private EffortCertificationReportDefinition reportDefinition;
    private Map<String, Integer> basicStatistics;
    private List<LedgerBalanceWithMessage> ledgerBalancesWithMessage;
    private final Map<String, Object> reportData;
    public static final String KEY_OF_STATISTICS_ENTRY = "statistics";
    public static final String KEY_OF_ERRORS_ENTRY = "errors";
    public static final String REPORT_YEAR = "reportYear";
    public static final String REPORT_NUMBER = "reportNumber";
    public static final String REPORT_PERIOD_BEGIN = "reportPeriodBegin";
    public static final String REPORT_PERIOD_END = "reportPeriodEnd";

    public ExtractProcessReportDataHolder() {
        this(null);
    }

    public ExtractProcessReportDataHolder(EffortCertificationReportDefinition reportDefinition) {
        this.reportDefinition = reportDefinition;
        this.basicStatistics = new HashMap<String, Integer>();
        this.ledgerBalancesWithMessage = new ArrayList<LedgerBalanceWithMessage>();
        this.reportData = new HashMap<String, Object>();
    }

    public void updateBasicStatistics(String key, Integer count) {
        if (this.basicStatistics.containsKey(key)) {
            Integer currentCount = this.basicStatistics.get(key);
            count = currentCount + count;
        }
        this.basicStatistics.put(key, count);
    }

    public EffortCertificationReportDefinition getReportDefinition() {
        return this.reportDefinition;
    }

    public void setReportDefinition(EffortCertificationReportDefinition reportDefinition) {
        this.reportDefinition = reportDefinition;
    }

    public Map<String, Integer> getBasicStatistics() {
        return this.basicStatistics;
    }

    public void setBasicStatistics(Map<String, Integer> basicStatistics) {
        this.basicStatistics = basicStatistics;
    }

    public List<LedgerBalanceWithMessage> getLedgerBalancesWithMessage() {
        return this.ledgerBalancesWithMessage;
    }

    public void setLedgerBalancesWithMessage(List<LedgerBalanceWithMessage> ledgerBalancesWithMessage) {
        this.ledgerBalancesWithMessage = ledgerBalancesWithMessage;
    }

    public Map<String, Object> getReportData() {
        this.reportData.put(REPORT_YEAR, this.reportDefinition.getUniversityFiscalYear());
        this.reportData.put(REPORT_NUMBER, this.reportDefinition.getEffortCertificationReportNumber());
        this.reportData.put(REPORT_PERIOD_BEGIN, this.reportDefinition.getEffortCertificationReportBeginPeriodCode() + "/" + this.reportDefinition.getEffortCertificationReportBeginFiscalYear());
        this.reportData.put(REPORT_PERIOD_END, this.reportDefinition.getEffortCertificationReportEndPeriodCode() + "/" + this.reportDefinition.getEffortCertificationReportEndFiscalYear());
        this.reportData.put(KEY_OF_STATISTICS_ENTRY, this.basicStatistics);
        this.reportData.put(KEY_OF_ERRORS_ENTRY, this.ledgerBalancesWithMessage);
        return this.reportData;
    }

    public String toString() {
        return this.getReportData().toString();
    }
}

