/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec;

public final class EffortParameterConstants {

    public static final String ACCOUNT_TYPES = "ACCOUNT_TYPES";
    public static final String CREATE_FISCAL_YEAR = "CREATE_FISCAL_YEAR";
    public static final String CREATE_REPORT_NUMBER = "CREATE_REPORT_NUMBER";
    public static final String EFFORT_CERTIFICATION_COMPONENT_CODE = "EffortCertification";
    public static final String EXTRACT_FISCAL_YEAR = "EXTRACT_FISCAL_YEAR";
    public static final String EXTRACT_REPORT_NUMBER = "EXTRACT_REPORT_NUMBER";
    public static final String FEDERAL_ACCOUNT_IND = "FEDERAL_ACCOUNT_IND";
    public static final String FEDERAL_ROUTE_IND = "FEDERAL_ROUTE_IND";
    public static final String RUN_IND = "RUN_IND";

    /**
     * Private Constructor since this is a constants class that should never be instantiated.
     */
    private EffortParameterConstants() {
    }
}
