/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec;

import org.kuali.kfs.sys.KFSPropertyConstants;

/**
 * Constants that represent a property name in an effort reporting business object.
 */
public final class EffortPropertyConstants {

    public static final String ACCOUNT_ACCOUNT_TYPE_CODE = KFSPropertyConstants.ACCOUNT + "." +
            KFSPropertyConstants.ACCOUNT_TYPE_CODE;
    public static final String COST_SHARE_SOURCE_SUB_ACCOUNT_NUMBER = "costShareSourceSubAccountNumber";
    public static final String EFFECTIVE_DATE = "effectiveDate";
    public static final String EFFORT_CERTIFICATION_BUILD_NUMBER = "effortCertificationBuildNumber";
    public static final String EFFORT_CERTIFICATION_CALCULATED_OVERALL_PERCENT =
            "effortCertificationCalculatedOverallPercent";
    public static final String EFFORT_CERTIFICATION_DETAIL_LINES = "effortCertificationDetailLines";
    public static final String EFFORT_CERTIFICATION_DOCUMENT_NEW_LINE = "newDetailLine";
    public static final String EFFORT_CERTIFICATION_ORIGINAL_PAYROLL_AMOUNT = "effortCertificationOriginalPayrollAmount";
    public static final String EFFORT_CERTIFICATION_PAYROLL_AMOUNT = "effortCertificationPayrollAmount";
    public static final String EFFORT_CERTIFICATION_REPORT_BEGIN_FISCAL_YEAR = "effortCertificationReportBeginFiscalYear";
    public static final String EFFORT_CERTIFICATION_REPORT_DEFINITION = "effortCertificationReportDefinition";
    public static final String EFFORT_CERTIFICATION_REPORT_END_FISCAL_YEAR = "effortCertificationReportEndFiscalYear";
    public static final String EFFORT_CERTIFICATION_REPORT_NUMBER = "effortCertificationReportNumber";
    public static final String EFFORT_CERTIFICATION_REPORT_POSITIONS = "effortCertificationReportPositions";
    public static final String EFFORT_CERTIFICATION_REPORT_TYPE_CODE = "effortCertificationReportTypeCode";
    public static final String EFFORT_CERTIFICATION_REPORT_POSITION_OBJECT_GROUP_CODE =
            "effortCertificationReportPositionObjectGroupCode";
    public static final String EFFORT_CERTIFICATION_UPDATED_OVERALL_PERCENT = "effortCertificationUpdatedOverallPercent";
    public static final String EXPENSE_TRANSFER_FISCAL_YEAR = "expenseTransferFiscalYear";
    public static final String LABOR_OBJECT_FRINGE_OR_SALARY_CODE = KFSPropertyConstants.LABOR_OBJECT + "." +
            KFSPropertyConstants.FINANCIAL_OBJECT_FRINGE_OR_SALARY_CODE;
    public static final String NEW_LINE_INDICATOR = "newLineIndicator";
    public static final String PERSISTED_PAYROLL_AMOUNT = "persistedPayrollAmount";
    public static final String SOURCE_ACCOUNT_NUMBER = "sourceAccountNumber";
    public static final String SOURCE_CHART_OF_ACCOUNTS_CODE = "sourceChartOfAccountsCode";
    public static final String SUMMARIZED_DETAIL_LINES = "summarizedDetailLines";

    /**
     * Private Constructor since this is a constants class that should never be instantiated.
     */
    private EffortPropertyConstants() {
    }
}
