/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.util;

import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.sys.KFSConstants;

/**
 * To hold the necessary information of ledger balance for the report generation
 */
public class LedgerBalanceWithMessage {

    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String positionNumber;
    private String employeeName;
    private String emplid;
    private String message;

    public LedgerBalanceWithMessage() {
        this(KFSConstants.EMPTY_STRING, KFSConstants.EMPTY_STRING, KFSConstants.EMPTY_STRING);
    }

    /**
     * @param emplid       the given employee id
     * @param employeeName the given employee name
     * @param message      the message associated with the given ledger balance
     */
    public LedgerBalanceWithMessage(final String emplid, final String employeeName, final String message) {
        super();
        chartOfAccountsCode = KFSConstants.EMPTY_STRING;
        accountNumber = KFSConstants.EMPTY_STRING;
        subAccountNumber = KFSConstants.EMPTY_STRING;
        financialObjectCode = KFSConstants.EMPTY_STRING;
        positionNumber = KFSConstants.EMPTY_STRING;
        this.emplid = emplid;
        this.employeeName = employeeName;
        this.message = message;
    }

    /**
     * @param ledgerBalance the given ledger balance
     * @param message       the message associated with the given ledger balance
     */
    public LedgerBalanceWithMessage(final LaborLedgerBalance ledgerBalance, final String message) {
        super();
        chartOfAccountsCode = ledgerBalance.getChartOfAccountsCode();
        accountNumber = ledgerBalance.getAccountNumber();
        subAccountNumber = ledgerBalance.getSubAccountNumber();
        financialObjectCode = ledgerBalance.getFinancialObjectCode();
        positionNumber = ledgerBalance.getPositionNumber();
        emplid = ledgerBalance.getEmplid();
        this.message = message;

        final Person employee = ledgerBalance.getLedgerPerson();
        employeeName = employee != null ? employee.getName() : KFSConstants.EMPTY_STRING;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return subAccountNumber;
    }

    public void setSubAccountNumber(final String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    public void setFinancialObjectCode(final String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getPositionNumber() {
        return positionNumber;
    }

    public void setPositionNumber(final String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public String getEmplid() {
        return emplid;
    }

    public void setEmplid(final String emplid) {
        this.emplid = emplid;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(final String employeeName) {
        this.employeeName = employeeName;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(final String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "[chartOfAccountsCode=" + getChartOfAccountsCode() + ", " + "accountNumber=" +
                getAccountNumber() + ", " + "subAccountNumber=" + getSubAccountNumber() + ", " +
                "financialObjectCode=" + getFinancialObjectCode() + ", " + "positionNumber=" +
                getPositionNumber() + ", " + "emplid=" + getEmplid() + ", " + "employeeName=" +
                getEmployeeName() + ", " + "message=" + getMessage() + "]";
    }
}
