/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cg.dto.HashMapElement;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.InstitutionalBudgetCategorySoapService;
import org.kuali.kra.external.budget.service.BudgetCategoryService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class BudgetCategoryServiceImpl
implements ExternalizableBusinessObjectService {
    protected static Logger LOG = Logger.getLogger(BudgetCategoryServiceImpl.class);
    protected ConfigurationService configurationService;

    protected BudgetCategoryService getWebService() {
        BudgetCategoryService institutionalBudgetCategoryService = (BudgetCategoryService)GlobalResourceLoader.getService((QName)KcConstants.BudgetCategory.SERVICE);
        if (institutionalBudgetCategoryService == null) {
            LOG.warn((Object)"Couldn't get BudgetCategoryService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            InstitutionalBudgetCategorySoapService ss = null;
            try {
                ss = new InstitutionalBudgetCategorySoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)("Could not intialize BudgetCategorySoapService: " + ex.getMessage()));
                throw new RuntimeException("Could not intialize BudgetCategorySoapService: " + ex.getMessage());
            }
            institutionalBudgetCategoryService = ss.getBudgetCategoryServicePort();
        }
        return institutionalBudgetCategoryService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        Collection budgetCategoryDTOs = this.findMatching(primaryKeys);
        if (budgetCategoryDTOs != null && budgetCategoryDTOs.iterator().hasNext()) {
            return (ExternalizableBusinessObject)budgetCategoryDTOs.iterator().next();
        }
        return null;
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        ArrayList<HashMapElement> hashMapList = new ArrayList<HashMapElement>();
        List<Object> budgetCategoryDTOs = new ArrayList();
        for (Map.Entry e : fieldValues.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (!KcConstants.BudgetCategory.KC_ALLOWABLE_CRITERIA_PARAMETERS.contains(key) || val.length() <= 0) continue;
            HashMapElement hashMapElement = new HashMapElement();
            hashMapElement.setKey(key);
            hashMapElement.setValue(val);
            hashMapList.add(hashMapElement);
        }
        if (hashMapList.size() == 0) {
            hashMapList = null;
        }
        try {
            budgetCategoryDTOs = this.getWebService().lookupBudgetCategories(hashMapList);
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        return budgetCategoryDTOs;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

